/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.config;

import com.hypherionmc.craterlib.core.config.ConfigController;
import com.hypherionmc.craterlib.core.config.formats.AbstractConfigFormat;
import com.hypherionmc.craterlib.core.config.formats.JsonConfigFormat;
import com.hypherionmc.craterlib.core.config.formats.TomlConfigFormat;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import shadow.hypherionmc.moonconfig.core.Config;

public abstract class AbstractConfig<S> {
    private final transient File configPath;
    private final transient String networkID;
    private final transient String configName;
    private final transient String modId;
    private transient boolean wasSaveCalled = false;
    private transient AbstractConfigFormat<S> configFormat;

    public AbstractConfig(String modId, String configName) {
        this(modId, null, configName);
    }

    public AbstractConfig(String modId, @Nullable String subFolder, String configName) {
        Config.setInsertionOrderPreserved(true);
        if (!((String)configName).endsWith(".toml") && !((String)configName).endsWith(".json")) {
            configName = (String)configName + ".toml";
        }
        File configDir = new File("config" + (String)(subFolder == null ? "" : File.separator + subFolder));
        this.configPath = new File(configDir, (String)configName);
        this.modId = modId;
        this.networkID = modId + ":conf_" + ((String)configName).replace(".toml", "").replace(".json", "").replace("-", "_").toLowerCase();
        this.configName = ((String)configName).replace(".toml", "").replace(".json", "");
        configDir.mkdirs();
        this.configFormat = ((String)configName).endsWith(".json") ? new JsonConfigFormat(this.configPath, this::onSave) : new TomlConfigFormat(this.configPath, this::onSave);
    }

    public void registerAndSetup(S config) {
        this.configFormat.register(config);
        ConfigController.register_config(this);
        this.configReloaded();
    }

    public void saveConfig(S config) {
        this.wasSaveCalled = true;
        this.configFormat.saveConfig(config);
    }

    private void onSave() {
        this.configReloaded();
        this.wasSaveCalled = false;
    }

    public S readConfig(S config) {
        return this.configFormat.readConfig(config);
    }

    public void migrateConfig(S config) {
        this.configFormat.migrateConfig(config);
    }

    public abstract void configReloaded();

    public File getConfigPath() {
        return this.configPath;
    }

    public String getNetworkID() {
        return this.networkID;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isWasSaveCalled() {
        return this.wasSaveCalled;
    }

    public AbstractConfigFormat<S> getConfigFormat() {
        return this.configFormat;
    }

    public void setConfigFormat(AbstractConfigFormat<S> configFormat) {
        this.configFormat = configFormat;
    }
}

