/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Supplier;
import link.infra.indium.mixin.renderer.ItemRendererAccessor;
import link.infra.indium.renderer.helper.ColorHelper;
import link.infra.indium.renderer.helper.VanillaModelEncoder;
import link.infra.indium.renderer.material.RenderMaterialImpl;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_325;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_7837;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private final class_325 colorMap;
    private final class_5819 random = new class_6575(42L);
    private final Supplier<class_5819> randomSupplier = () -> {
        this.random.method_43052(42L);
        return this.random;
    };
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            ItemRenderContext.this.renderQuad(this);
        }
    };
    private final BakedModelConsumerImpl vanillaModelConsumer = new BakedModelConsumerImpl();
    private class_1799 itemStack;
    private class_811 transformMode;
    private class_4587 matrixStack;
    private class_4597 vertexConsumerProvider;
    private int lightmap;
    private boolean isDefaultTranslucent;
    private boolean isTranslucentDirect;
    private boolean isDefaultGlint;
    private boolean isGlintDynamicDisplay;
    private class_4587.class_4665 dynamicDisplayGlintEntry;
    private class_4588 translucentVertexConsumer;
    private class_4588 cutoutVertexConsumer;
    private class_4588 translucentGlintVertexConsumer;
    private class_4588 cutoutGlintVertexConsumer;

    public boolean isFaceCulled(@Nullable class_2350 face) {
        throw new IllegalStateException("isFaceCulled can only be called on a block render context.");
    }

    public class_811 itemTransformationMode() {
        return this.transformMode;
    }

    public ItemRenderContext(class_325 colorMap) {
        this.colorMap = colorMap;
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.vanillaModelConsumer;
    }

    public void renderModel(class_1799 itemStack, class_811 transformMode, boolean invert, class_4587 matrixStack, class_4597 vertexConsumerProvider, int lightmap, int overlay, class_1087 model) {
        this.itemStack = itemStack;
        this.transformMode = transformMode;
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.computeOutputInfo();
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        model.emitItemQuads(itemStack, this.randomSupplier, (RenderContext)this);
        this.itemStack = null;
        this.matrixStack = null;
        this.vertexConsumerProvider = null;
        this.dynamicDisplayGlintEntry = null;
        this.translucentVertexConsumer = null;
        this.cutoutVertexConsumer = null;
        this.translucentGlintVertexConsumer = null;
        this.cutoutGlintVertexConsumer = null;
    }

    private void computeOutputInfo() {
        this.isDefaultTranslucent = true;
        this.isTranslucentDirect = true;
        class_1792 item = this.itemStack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2680 state = blockItem.method_7711().method_9564();
            class_1921 renderLayer = class_4696.method_23679((class_2680)state);
            if (renderLayer != class_1921.method_23583()) {
                this.isDefaultTranslucent = false;
            }
            if (this.transformMode != class_811.field_4317 && !this.transformMode.method_29998()) {
                this.isTranslucentDirect = false;
            }
        }
        this.isDefaultGlint = this.itemStack.method_7958();
        this.isGlintDynamicDisplay = ItemRendererAccessor.indium$usesDynamicDisplay(this.itemStack);
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        boolean emissive = mat.emissive();
        class_4588 vertexConsumer = this.getVertexConsumer(mat.blendMode(), mat.glint());
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        if (colorIndex != -1) {
            int itemColor = this.colorMap.method_1704(this.itemStack, colorIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(itemColor, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
            }
        }
    }

    private class_4588 getVertexConsumer(BlendMode blendMode, TriState glintMode) {
        boolean glint;
        boolean translucent;
        if (blendMode == BlendMode.DEFAULT) {
            translucent = this.isDefaultTranslucent;
        } else {
            boolean bl = translucent = blendMode == BlendMode.TRANSLUCENT;
        }
        if (glintMode == TriState.DEFAULT) {
            glint = this.isDefaultGlint;
        } else {
            boolean bl = glint = glintMode == TriState.TRUE;
        }
        if (translucent) {
            if (glint) {
                if (this.translucentGlintVertexConsumer == null) {
                    this.translucentGlintVertexConsumer = this.createTranslucentVertexConsumer(true);
                }
                return this.translucentGlintVertexConsumer;
            }
            if (this.translucentVertexConsumer == null) {
                this.translucentVertexConsumer = this.createTranslucentVertexConsumer(false);
            }
            return this.translucentVertexConsumer;
        }
        if (glint) {
            if (this.cutoutGlintVertexConsumer == null) {
                this.cutoutGlintVertexConsumer = this.createCutoutVertexConsumer(true);
            }
            return this.cutoutGlintVertexConsumer;
        }
        if (this.cutoutVertexConsumer == null) {
            this.cutoutVertexConsumer = this.createCutoutVertexConsumer(false);
        }
        return this.cutoutVertexConsumer;
    }

    private class_4588 createTranslucentVertexConsumer(boolean glint) {
        if (glint && this.isGlintDynamicDisplay) {
            return this.createDynamicDisplayGlintVertexConsumer(class_310.method_29611() && !this.isTranslucentDirect ? class_4722.method_29382() : class_4722.method_24076());
        }
        if (this.isTranslucentDirect) {
            return class_918.method_29711((class_4597)this.vertexConsumerProvider, (class_1921)class_4722.method_24076(), (boolean)true, (boolean)glint);
        }
        if (class_310.method_29611()) {
            return class_918.method_23181((class_4597)this.vertexConsumerProvider, (class_1921)class_4722.method_29382(), (boolean)true, (boolean)glint);
        }
        return class_918.method_23181((class_4597)this.vertexConsumerProvider, (class_1921)class_4722.method_24076(), (boolean)true, (boolean)glint);
    }

    private class_4588 createCutoutVertexConsumer(boolean glint) {
        if (glint && this.isGlintDynamicDisplay) {
            return this.createDynamicDisplayGlintVertexConsumer(class_4722.method_24074());
        }
        return class_918.method_29711((class_4597)this.vertexConsumerProvider, (class_1921)class_4722.method_24074(), (boolean)true, (boolean)glint);
    }

    private class_4588 createDynamicDisplayGlintVertexConsumer(class_1921 layer) {
        if (this.dynamicDisplayGlintEntry == null) {
            this.dynamicDisplayGlintEntry = this.matrixStack.method_23760().method_56822();
            if (this.transformMode == class_811.field_4317) {
                class_7837.method_46414((Matrix4f)this.dynamicDisplayGlintEntry.method_23761(), (float)0.5f);
            } else if (this.transformMode.method_29998()) {
                class_7837.method_46414((Matrix4f)this.dynamicDisplayGlintEntry.method_23761(), (float)0.75f);
            }
        }
        return class_918.method_30114((class_4597)this.vertexConsumerProvider, (class_1921)layer, (class_4587.class_4665)this.dynamicDisplayGlintEntry);
    }

    private class BakedModelConsumerImpl
    implements RenderContext.BakedModelConsumer {
        private BakedModelConsumerImpl() {
        }

        public void accept(class_1087 model) {
            this.accept(model, null);
        }

        public void accept(class_1087 model, @Nullable class_2680 state) {
            VanillaModelEncoder.emitItemQuads(model, state, ItemRenderContext.this.randomSupplier, ItemRenderContext.this);
        }
    }
}

