/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_7833;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.geo.NormalPlaneF;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.vec.Vec3f;

public enum Facing {
    DOWN(Axis.Y, false, new class_2382(0, -1, 0), -1){

        @Override
        public Facing opposite() {
            return UP;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11033;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1322;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40715;
        }

        @Override
        public class_238 set(class_238 bb, double value) {
            return bb.method_35575(value);
        }

        @Override
        public float get(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return minY;
        }

        @Override
        public double get(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return minY;
        }

        @Override
        public int get(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            return minY;
        }
    }
    ,
    UP(Axis.Y, true, new class_2382(0, 1, 0), -1){

        @Override
        public Facing opposite() {
            return DOWN;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11036;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1325;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40716;
        }

        @Override
        public class_238 set(class_238 bb, double value) {
            return bb.method_35578(value);
        }

        @Override
        public float get(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return maxY;
        }

        @Override
        public double get(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return maxY;
        }

        @Override
        public int get(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            return maxY;
        }
    }
    ,
    NORTH(Axis.Z, false, new class_2382(0, 0, -1), 2){

        @Override
        public Facing opposite() {
            return SOUTH;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11043;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1321;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40717;
        }

        @Override
        public class_238 set(class_238 bb, double value) {
            return bb.method_35576(value);
        }

        @Override
        public float get(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return minZ;
        }

        @Override
        public double get(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return minZ;
        }

        @Override
        public int get(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            return minZ;
        }
    }
    ,
    SOUTH(Axis.Z, true, new class_2382(0, 0, 1), 0){

        @Override
        public Facing opposite() {
            return NORTH;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11035;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1324;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40718;
        }

        @Override
        public class_238 set(class_238 bb, double value) {
            return bb.method_35579(value);
        }

        @Override
        public float get(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return maxZ;
        }

        @Override
        public double get(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return maxZ;
        }

        @Override
        public int get(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            return maxZ;
        }
    }
    ,
    WEST(Axis.X, false, new class_2382(-1, 0, 0), 1){

        @Override
        public Facing opposite() {
            return EAST;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11039;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1323;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40713;
        }

        @Override
        public class_238 set(class_238 bb, double value) {
            return bb.method_35574(value);
        }

        @Override
        public float get(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return minX;
        }

        @Override
        public double get(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return minX;
        }

        @Override
        public int get(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            return minX;
        }
    }
    ,
    EAST(Axis.X, true, new class_2382(1, 0, 0), 3){

        @Override
        public Facing opposite() {
            return WEST;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11034;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1320;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40714;
        }

        @Override
        public class_238 set(class_238 bb, double value) {
            return bb.method_35577(value);
        }

        @Override
        public float get(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return maxX;
        }

        @Override
        public double get(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return maxX;
        }

        @Override
        public int get(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            return maxX;
        }
    };

    public static final Facing[] VALUES;
    public static final Facing[] HORIZONTA_VALUES;
    public static final String[] FACING_NAMES;
    public static final String[] HORIZONTAL_FACING_NAMES;
    public final String name = this.name().toLowerCase();
    public final Axis axis;
    public final boolean positive;
    public final class_2382 normal;
    public final NormalPlaneF plane;
    public final int horizontalIndex;

    public static Facing get(int index) {
        return VALUES[index];
    }

    public static Facing get(class_2350 direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> DOWN;
            case class_2350.field_11036 -> UP;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
        };
    }

    public static Facing get(Axis axis, boolean positive) {
        return switch (axis) {
            case Axis.X -> {
                if (positive) {
                    yield EAST;
                }
                yield WEST;
            }
            case Axis.Y -> {
                if (positive) {
                    yield UP;
                }
                yield DOWN;
            }
            case Axis.Z -> {
                if (positive) {
                    yield SOUTH;
                }
                yield NORTH;
            }
            default -> throw new IllegalArgumentException();
        };
    }

    public static Facing getHorizontal(int index) {
        return HORIZONTA_VALUES[index];
    }

    public static Facing of(class_1657 player) {
        Facing facing = Facing.get(player.method_5735());
        if (player.method_36455() > 45.0f) {
            facing = DOWN;
        }
        if (player.method_36455() < -45.0f) {
            facing = UP;
        }
        return facing;
    }

    public static Facing ofNormal(class_2382 vec) {
        if (vec.method_10263() > 0) {
            return EAST;
        }
        if (vec.method_10263() < 0) {
            return WEST;
        }
        if (vec.method_10264() > 0) {
            return UP;
        }
        if (vec.method_10264() < 0) {
            return DOWN;
        }
        if (vec.method_10260() > 0) {
            return SOUTH;
        }
        if (vec.method_10260() < 0) {
            return NORTH;
        }
        throw new IllegalArgumentException();
    }

    public static Facing direction(class_2382 pos, class_2382 second) {
        if (pos.method_10263() == second.method_10263()) {
            if (pos.method_10264() == second.method_10264()) {
                if (pos.method_10260() == second.method_10260() + 1) {
                    return SOUTH;
                }
                return NORTH;
            }
            if (pos.method_10264() == second.method_10264() + 1) {
                return UP;
            }
            return DOWN;
        }
        if (pos.method_10263() == second.method_10263() + 1) {
            return EAST;
        }
        return WEST;
    }

    public static Facing nearest(Vec3f vec) {
        return Facing.nearest(vec.x, vec.y, vec.z);
    }

    public static Facing nearest(float x, float y, float z) {
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return null;
        }
        Facing facing = null;
        float distance = Float.MIN_VALUE;
        for (int i = 0; i < VALUES.length; ++i) {
            Facing f = VALUES[i];
            float newDistance = x * (float)f.normal.method_10263() + y * (float)f.normal.method_10264() + z * (float)f.normal.method_10260();
            if (!(newDistance > distance)) continue;
            distance = newDistance;
            facing = f;
        }
        return facing;
    }

    private Facing(Axis axis, boolean positive, class_2382 normal, int horizontalIndex) {
        this.axis = axis;
        this.positive = positive;
        this.normal = normal;
        this.plane = new NormalPlaneF(this);
        this.horizontalIndex = horizontalIndex;
    }

    public int offset() {
        return this.positive ? 1 : -1;
    }

    public int offset(Axis axis) {
        if (this.axis == axis) {
            return this.offset();
        }
        return 0;
    }

    public class_2561 translate() {
        return class_2561.method_43471((String)("facing." + this.name));
    }

    public abstract Facing opposite();

    public abstract class_2350 toVanilla();

    public Axis one() {
        return this.axis.one();
    }

    public Axis two() {
        return this.axis.two();
    }

    public Axis getUAxis() {
        return switch (this.axis) {
            case Axis.X -> Axis.Z;
            case Axis.Y -> Axis.X;
            case Axis.Z -> Axis.X;
            default -> null;
        };
    }

    public Axis getVAxis() {
        return switch (this.axis) {
            case Axis.X -> Axis.Y;
            case Axis.Y -> Axis.Z;
            case Axis.Z -> Axis.Y;
            default -> null;
        };
    }

    public float getU(float x, float y, float z) {
        return switch (this.axis) {
            case Axis.X -> z;
            case Axis.Y -> x;
            case Axis.Z -> x;
            default -> 0.0f;
        };
    }

    public float getV(float x, float y, float z) {
        return switch (this.axis) {
            case Axis.X -> y;
            case Axis.Y -> z;
            case Axis.Z -> y;
            default -> 0.0f;
        };
    }

    public abstract double get(class_238 var1);

    public abstract class_238 set(class_238 var1, double var2);

    public abstract class_7833 rotation();

    public abstract float get(float var1, float var2, float var3, float var4, float var5, float var6);

    public abstract double get(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract int get(int var1, int var2, int var3, int var4, int var5, int var6);

    public Facing transform(IntMatrix3c matrix) {
        return Facing.ofNormal(matrix.transform(this.normal));
    }

    static {
        VALUES = new Facing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        HORIZONTA_VALUES = new Facing[]{SOUTH, WEST, NORTH, EAST};
        FACING_NAMES = new String[]{"down", "up", "north", "south", "west", "east"};
        HORIZONTAL_FACING_NAMES = new String[]{"north", "south", "west", "east"};
    }
}

