/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.network.CreativeNetworkField;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetworkPacket<T extends CreativePacket> {
    public final class_8710.class_9154<T> sid;
    public final class_8710.class_9154<T> cid;
    public final Class<T> classType;
    public final Supplier<T> supplier;
    public List<CreativeNetworkField> parsers = new ArrayList<CreativeNetworkField>();
    public final boolean fabric;

    public CreativeNetworkPacket(class_2960 id, Class<T> classType, Supplier<T> supplier, boolean fabric) {
        this.sid = new class_8710.class_9154(class_2960.method_43902((String)id.method_12836(), (String)(id.method_12832() + "s")));
        this.cid = new class_8710.class_9154(class_2960.method_43902((String)id.method_12836(), (String)(id.method_12832() + "c")));
        this.classType = classType;
        this.supplier = supplier;
        this.fabric = fabric;
        for (Field field : this.classType.getFields()) {
            if (Modifier.isTransient(field.getModifiers()) || CreativeNetwork.isSideOnlyPresent(field)) continue;
            CreativeNetworkField parser = CreativeNetworkField.create(field);
            if (parser != null) {
                this.parsers.add(parser);
                continue;
            }
            throw new RuntimeException("Could not find parser for " + classType.getName() + "." + field.getName() + "! type: " + field.getType().getName());
        }
    }

    public void write(T packet, class_9129 buffer, class_2598 flow) {
        for (CreativeNetworkField parser : this.parsers) {
            parser.write((CreativePacket)packet, buffer, flow);
        }
    }

    public T read(class_9129 buffer, class_2598 flow) {
        CreativePacket message = (CreativePacket)this.supplier.get();
        for (CreativeNetworkField parser : this.parsers) {
            parser.read(message, buffer, flow);
        }
        message.setType(!this.fabric && flow == class_2598.field_11942 ? this.cid : this.sid);
        return (T)message;
    }
}

