/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.inline.TmpGetters;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import io.github.kosmx.emotes.main.network.ClientPacketManager;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;

public class MainClientInit {
    public static void init() {
        MainClientInit.loadEmotes();
        ClientPacketManager.init();
        ClientEmotePlay.init();
    }

    public static void loadEmotes() {
        UniversalEmoteSerializer.loadEmotes();
        EmoteHolder.clearEmotes();
        EmoteHolder.addEmoteToList(UniversalEmoteSerializer.hiddenServerEmotes);
    }

    public static void playDebugEmote() {
        EmoteInstance.instance.getLogger().log(Level.INFO, "Playing debug emote");
        Path location = null;
        for (AnimationFormat source : AnimationFormat.values()) {
            location = EmoteInstance.instance.getGameDirectory().resolve("emote." + source.getExtension());
            if (location.toFile().isFile()) break;
        }
        if (location == null) {
            return;
        }
        try {
            InputStream reader = Files.newInputStream(location, new OpenOption[0]);
            EmoteHolder emoteHolder = new EmoteHolder(UniversalEmoteSerializer.readData(reader, location.getFileName().toString()).get(0));
            reader.close();
            if (TmpGetters.getClientMethods().getMainPlayer() != null) {
                emoteHolder.playEmote(TmpGetters.getClientMethods().getMainPlayer());
            }
        }
        catch (Exception e) {
            EmoteInstance.instance.getLogger().log(Level.INFO, "Error while importing debug emote.", true);
            EmoteInstance.instance.getLogger().log(Level.INFO, e.getMessage());
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }
}

