/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.arch.network.EmotesMixinConnection;
import io.github.kosmx.emotes.common.network.EmoteStreamHelper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractServerNetwork
implements INetworkInstance {
    @NotNull
    protected final EmoteStreamHelper streamHelper = new ServerStreamHelper();

    @NotNull
    protected abstract EmotesMixinConnection getServerConnection();

    @Override
    public HashMap<Byte, Byte> getRemoteVersions() {
        return this.getServerConnection().emotecraft$getRemoteVersions();
    }

    @Override
    public void setVersions(HashMap<Byte, Byte> map) {
        this.getServerConnection().emotecraft$setVersions(map);
    }

    abstract void sendEmotePacket(ByteBuffer var1);

    abstract void sendStreamPacket(ByteBuffer var1);

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public int getRemoteVersion() {
        return 8;
    }

    @Override
    public boolean isServerTrackingPlayState() {
        return true;
    }

    @Override
    public int maxDataSize() {
        return 32751;
    }

    @Nullable
    public ByteBuffer receiveStreamChunk(ByteBuffer buffer) {
        return this.streamHelper.receiveStream(buffer);
    }

    protected class ServerStreamHelper
    extends EmoteStreamHelper {
        protected ServerStreamHelper() {
        }

        @Override
        protected int getMaxPacketSize() {
            return AbstractServerNetwork.this.maxDataSize();
        }

        @Override
        protected void sendPlayPacket(ByteBuffer buffer) {
            AbstractServerNetwork.this.sendEmotePacket(buffer);
        }

        @Override
        protected void sendStreamChunk(ByteBuffer buffer) {
            AbstractServerNetwork.this.sendStreamPacket(buffer);
        }
    }
}

