/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class SourceLinePlayerRemovePacket
implements Packet<ClientPacketTcpHandler> {
    private UUID lineId;
    private UUID playerId;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.lineId = PacketUtil.readUUID(in);
        this.playerId = PacketUtil.readUUID(in);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.lineId));
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.playerId));
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public SourceLinePlayerRemovePacket(UUID lineId, UUID playerId) {
        this.lineId = lineId;
        this.playerId = playerId;
    }

    public SourceLinePlayerRemovePacket() {
    }

    public String toString() {
        return "SourceLinePlayerRemovePacket(lineId=" + this.getLineId() + ", playerId=" + this.getPlayerId() + ")";
    }

    public UUID getLineId() {
        return this.lineId;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }
}

