/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.connection;

import com.google.common.collect.Maps;
import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.sound.sampled.AudioFormat;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.MinecraftUtil;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.mod.channel.ByteArrayCodec;
import su.plo.slib.mod.channel.ByteArrayPayload;
import su.plo.slib.mod.channel.ModChannelManager;
import su.plo.voice.api.client.audio.capture.AudioCapture;
import su.plo.voice.api.client.audio.capture.ClientActivationManager;
import su.plo.voice.api.client.audio.device.AlContextOutputDevice;
import su.plo.voice.api.client.audio.line.ClientSourceLineManager;
import su.plo.voice.api.client.audio.source.ClientSourceManager;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.client.event.connection.ConnectionKeyPairGenerateEvent;
import su.plo.voice.api.client.event.connection.ServerInfoInitializedEvent;
import su.plo.voice.api.client.event.connection.TcpClientPacketReceivedEvent;
import su.plo.voice.api.client.event.connection.VoicePlayerConnectedEvent;
import su.plo.voice.api.client.event.connection.VoicePlayerDisconnectedEvent;
import su.plo.voice.api.client.event.connection.VoicePlayerUpdateEvent;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.event.socket.UdpClientConnectEvent;
import su.plo.voice.api.client.socket.UdpClient;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.connection.VoiceServerInfo;
import su.plo.voice.client.event.language.LanguageChangedEvent;
import su.plo.voice.client.socket.NettyUdpClient;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.encryption.EncryptionInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;
import su.plo.voice.proto.packets.tcp.clientbound.ActivationRegisterPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ActivationUnregisterPacket;
import su.plo.voice.proto.packets.tcp.clientbound.AnimatedActionBarPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ConfigPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ConfigPlayerInfoPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ConnectionPacket;
import su.plo.voice.proto.packets.tcp.clientbound.DistanceVisualizePacket;
import su.plo.voice.proto.packets.tcp.clientbound.LanguagePacket;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerDisconnectPacket;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerInfoRequestPacket;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerInfoUpdatePacket;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerListPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SelfSourceInfoPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayerAddPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayerRemovePacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayersListPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLineRegisterPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLineUnregisterPacket;
import su.plo.voice.proto.packets.tcp.serverbound.LanguageRequestPacket;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerInfoPacket;
import su.plo.voice.server.ModVoiceServer;

public final class ModServerConnection
implements ServerConnection {
    private static final Logger LOGGER = LogManager.getLogger(ModServerConnection.class);
    private final BaseVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final ClientSourceLineManager sourceLines;
    private final ClientActivationManager activations;
    private final ClientSourceManager sources;
    private final class_2535 connection;
    private KeyPair keyPair;
    private final Map<UUID, VoicePlayerInfo> playerById = Maps.newConcurrentMap();
    @NotNull
    private Map<String, String> language = Maps.newHashMap();
    @Nullable
    private EncryptionInfo encryptionInfo;

    public ModServerConnection(@NotNull BaseVoiceClient voiceClient, @NotNull class_2535 connection) {
        this.voiceClient = voiceClient;
        this.config = voiceClient.getConfig();
        this.sourceLines = voiceClient.getSourceLineManager();
        this.activations = voiceClient.getActivationManager();
        this.sources = voiceClient.getSourceManager();
        this.connection = connection;
    }

    @Override
    @NotNull
    public SocketAddress getRemoteAddress() {
        return this.connection.method_10755();
    }

    @Override
    public void sendPacket(@NotNull Packet<?> packet, boolean checkUdpConnection) {
        if (!this.connection.method_10758()) {
            return;
        }
        if (class_310.method_1551().method_1562() == null) {
            return;
        }
        if (checkUdpConnection && !this.voiceClient.getUdpClientManager().isConnected()) {
            return;
        }
        byte[] encoded = PacketTcpCodec.encode(packet);
        if (encoded == null) {
            return;
        }
        ByteArrayCodec codec = ModChannelManager.Companion.getOrRegisterCodec(ModVoiceServer.CHANNEL);
        this.connection.method_10743(ClientPlayNetworking.createC2SPacket((class_8710)new ByteArrayPayload(codec.getType(), encoded)));
    }

    @Override
    @NotNull
    public String getRemoteIp() {
        SocketAddress socketAddress = this.getRemoteAddress();
        if (!(socketAddress instanceof InetSocketAddress) && !(socketAddress instanceof LocalAddress)) {
            throw new IllegalStateException("Not connected to any server");
        }
        String serverIp = "127.0.0.1";
        if (socketAddress instanceof InetSocketAddress) {
            serverIp = ((InetSocketAddress)socketAddress).getHostName();
        }
        return serverIp;
    }

    @Override
    @NotNull
    public Collection<VoicePlayerInfo> getPlayers() {
        return this.playerById.values();
    }

    @Override
    public Optional<VoicePlayerInfo> getPlayerById(@NotNull UUID playerId) {
        return Optional.ofNullable(this.playerById.get(playerId));
    }

    @Override
    public Optional<VoicePlayerInfo> getLocalPlayer() {
        return Optional.ofNullable(class_310.method_1551().field_1724).flatMap(player -> this.getPlayerById(player.method_5667()));
    }

    @Override
    @NotNull
    public KeyPair getKeyPair() {
        if (this.keyPair == null) {
            throw new IllegalStateException("KeyPair is not initialized");
        }
        return this.keyPair;
    }

    @Override
    public Optional<EncryptionInfo> getEncryptionInfo() {
        return Optional.ofNullable(this.encryptionInfo);
    }

    @Override
    public void close() {
        this.voiceClient.setServerInfo(null);
        this.playerById.clear();
        this.voiceClient.getAudioCapture().stop();
        this.voiceClient.getSourceManager().clear();
        this.voiceClient.getSourceLineManager().clear();
        this.voiceClient.getActivationManager().clear();
        this.voiceClient.getDeviceManager().clear();
        this.voiceClient.getDeviceManager().stopJob();
    }

    public void generateKeyPair() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        KeyPair pair = generator.generateKeyPair();
        ConnectionKeyPairGenerateEvent event = new ConnectionKeyPairGenerateEvent(pair);
        this.voiceClient.getEventBus().fire(event);
        this.keyPair = event.getKeyPair();
    }

    public void handle(Packet<PacketHandler> packet) {
        TcpClientPacketReceivedEvent event = new TcpClientPacketReceivedEvent(this, packet);
        this.voiceClient.getEventBus().fire(event);
        if (event.isCancelled()) {
            return;
        }
        try {
            packet.handle(this);
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle packet: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void handle(@NotNull ConnectionPacket packet) {
        this.voiceClient.getUdpClientManager().removeClient(UdpClientClosedEvent.Reason.RECONNECT);
        UdpClient client = new NettyUdpClient(this.voiceClient, this.config, packet.getSecret());
        UdpClientConnectEvent connectEvent = new UdpClientConnectEvent(client, packet);
        this.voiceClient.getEventBus().fire(connectEvent);
        if (connectEvent.isCancelled()) {
            return;
        }
        client = connectEvent.getClient();
        this.voiceClient.getUdpClientManager().setClient(client);
        this.voiceClient.getEventBus().register(this.voiceClient, client);
        String ip = packet.getIp();
        if (ip.equals("0.0.0.0")) {
            ip = this.getRemoteIp();
        }
        try {
            client.connect(ip, packet.getPort());
        }
        catch (Exception e) {
            LOGGER.error("Failed to connect to the UDP server", (Throwable)e);
        }
    }

    @Override
    public void handle(@NotNull ConfigPacket packet) {
        Optional<UdpClient> client = this.voiceClient.getUdpClientManager().getClient();
        if (!client.isPresent()) {
            LOGGER.warn("Config packet is received before UDP is connected");
            return;
        }
        Optional<InetSocketAddress> remoteAddress = client.get().getRemoteAddress();
        if (!remoteAddress.isPresent()) {
            LOGGER.warn("Config packet is received before UDP is connected");
            return;
        }
        this.encryptionInfo = packet.getEncryption();
        Encryption encryption = null;
        if (this.encryptionInfo != null) {
            try {
                Cipher decryptCipher = Cipher.getInstance("RSA");
                decryptCipher.init(2, this.keyPair.getPrivate());
                byte[] encryptionData = decryptCipher.doFinal(this.encryptionInfo.getData());
                encryption = this.voiceClient.getEncryptionManager().create(this.encryptionInfo.getAlgorithm(), encryptionData);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize encryption with name {}", (Object)this.encryptionInfo.getAlgorithm(), (Object)e);
                this.voiceClient.getUdpClientManager().removeClient(UdpClientClosedEvent.Reason.DISCONNECT);
                return;
            }
        }
        VoiceServerInfo serverInfo = new VoiceServerInfo(this.voiceClient, packet.getServerId(), client.get().getSecret(), remoteAddress.get(), encryption, packet);
        this.voiceClient.setServerInfo(serverInfo);
        Optional<VoiceClientConfig.Server> configServer = this.voiceClient.getConfig().getServers().getById(serverInfo.getServerId());
        if (!configServer.isPresent()) {
            this.voiceClient.getConfig().getServers().put(serverInfo.getServerId(), new VoiceClientConfig.Server());
        }
        serverInfo.getVoiceInfo().getSourceLines().forEach(sourceLine -> {
            try {
                this.voiceClient.getSourceLineManager().register((SourceLine)sourceLine);
            }
            catch (Exception e) {
                LOGGER.error("Failed to register source line {}", sourceLine, (Object)e);
            }
        });
        serverInfo.getVoiceInfo().getActivations().forEach(activation -> {
            try {
                this.voiceClient.getActivationManager().register((Activation)activation);
            }
            catch (Exception e) {
                LOGGER.error("Failed to register activation {}", activation, (Object)e);
            }
        });
        AudioCapture audioCapture = this.voiceClient.getAudioCapture();
        audioCapture.start();
        audioCapture.initialize(serverInfo);
        AudioFormat format = new AudioFormat(serverInfo.getVoiceInfo().getCaptureInfo().getSampleRate(), 16, 1, true, false);
        try {
            AlContextOutputDevice outputDevice = this.voiceClient.getDeviceManager().openOutputDevice(format);
            this.voiceClient.getDeviceManager().setOutputDevice(outputDevice);
        }
        catch (Exception e) {
            LOGGER.error("Failed to open primary OpenAL output device", (Throwable)e);
        }
        this.voiceClient.getDeviceManager().startJob();
        ServerInfoInitializedEvent event = new ServerInfoInitializedEvent(serverInfo, packet);
        this.voiceClient.getEventBus().fire(event);
        this.sendPacket(new LanguageRequestPacket(class_310.method_1551().field_1690.field_1883));
    }

    @Override
    public void handle(@NotNull PlayerInfoRequestPacket packet) {
        this.sendPacket(new PlayerInfoPacket(MinecraftUtil.getVersion(), this.voiceClient.getVersion(), this.keyPair.getPublic().getEncoded(), (Boolean)this.voiceClient.getConfig().getVoice().getDisabled().value(), (Boolean)this.voiceClient.getConfig().getVoice().getMicrophoneDisabled().value()), false);
    }

    @Override
    public void handle(@NotNull LanguagePacket packet) {
        this.language = packet.getLanguage();
    }

    @Override
    public void handle(@NotNull ConfigPlayerInfoPacket packet) {
        this.voiceClient.getServerInfo().ifPresent(serverInfo -> ((VoiceServerInfo.VoiceServerPlayerInfo)serverInfo.getPlayerInfo()).update(packet.getPermissions()));
    }

    @Override
    public void handle(@NotNull PlayerListPacket packet) {
        packet.getPlayers().forEach(player -> this.playerById.put(player.getPlayerId(), (VoicePlayerInfo)player));
    }

    @Override
    public void handle(@NotNull PlayerInfoUpdatePacket packet) {
        if (this.playerById.put(packet.getPlayerInfo().getPlayerId(), packet.getPlayerInfo()) == null) {
            this.voiceClient.getEventBus().fire(new VoicePlayerConnectedEvent(packet.getPlayerInfo()));
        } else {
            this.voiceClient.getEventBus().fire(new VoicePlayerUpdateEvent(packet.getPlayerInfo()));
        }
    }

    @Override
    public void handle(@NotNull PlayerDisconnectPacket packet) {
        if (Optional.ofNullable(class_310.method_1551().field_1724).map(player -> player.method_5667().equals(packet.getPlayerId())).orElse(false).booleanValue()) {
            this.voiceClient.getUdpClientManager().removeClient(UdpClientClosedEvent.Reason.DISCONNECT);
            return;
        }
        this.playerById.remove(packet.getPlayerId());
        this.voiceClient.getEventBus().fire(new VoicePlayerDisconnectedEvent(packet.getPlayerId()));
    }

    @Override
    public void handle(@NotNull SourceAudioEndPacket packet) {
        if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
            return;
        }
        this.sources.getSourceById(packet.getSourceId(), false).ifPresent(source2 -> source2.process(packet));
    }

    @Override
    public void handle(@NotNull SourceInfoPacket packet) {
        if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
            return;
        }
        if (packet.getSourceInfo() instanceof PlayerSourceInfo) {
            PlayerSourceInfo sourceInfo = (PlayerSourceInfo)packet.getSourceInfo();
            this.playerById.put(sourceInfo.getPlayerInfo().getPlayerId(), sourceInfo.getPlayerInfo());
        }
        this.sources.createOrUpdateSource(packet.getSourceInfo());
    }

    @Override
    public void handle(@NotNull SelfSourceInfoPacket packet) {
        this.sources.updateSelfSourceInfo(packet.getSourceInfo());
    }

    @Override
    public void handle(@NotNull SourceLineRegisterPacket packet) {
        this.sourceLines.register(packet.getSourceLine());
    }

    @Override
    public void handle(@NotNull SourceLineUnregisterPacket packet) {
        this.sourceLines.unregister(packet.getLineId());
    }

    @Override
    public void handle(@NotNull SourceLinePlayerAddPacket packet) {
        this.sourceLines.getLineById(packet.getLineId()).ifPresent(line -> line.addPlayer(packet.getPlayer()));
    }

    @Override
    public void handle(@NotNull SourceLinePlayerRemovePacket packet) {
        this.sourceLines.getLineById(packet.getLineId()).ifPresent(line -> line.removePlayer(packet.getPlayerId()));
    }

    @Override
    public void handle(@NotNull SourceLinePlayersListPacket packet) {
        this.sourceLines.getLineById(packet.getLineId()).ifPresent(sourceLine -> {
            sourceLine.clearPlayers();
            packet.getPlayers().forEach(sourceLine::addPlayer);
        });
    }

    @Override
    public void handle(@NotNull ActivationRegisterPacket packet) {
        Optional<ServerInfo> serverInfo = this.voiceClient.getServerInfo();
        if (!serverInfo.isPresent()) {
            return;
        }
        this.activations.register(packet.getActivation());
    }

    @Override
    public void handle(@NotNull ActivationUnregisterPacket packet) {
        this.activations.unregister(packet.getActivationId());
    }

    @Override
    public void handle(@NotNull DistanceVisualizePacket packet) {
        this.voiceClient.getDistanceVisualizer().render(packet.getRadius(), packet.getHexColor(), packet.getPosition());
    }

    @Override
    public void handle(@NotNull AnimatedActionBarPacket packet) {
        class_310.method_1551().field_1705.method_1758(RenderUtil.getTextConverter().convertFromJson(packet.getJsonComponent()), true);
    }

    @EventSubscribe
    public void onUdpClosed(@NotNull UdpClientClosedEvent event) {
        this.close();
    }

    @EventSubscribe
    public void onLanguageChanged(@NotNull LanguageChangedEvent event) {
        this.sendPacket(new LanguageRequestPacket(event.getLanguage()));
    }

    public class_2535 getConnection() {
        return this.connection;
    }

    @Override
    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    @Override
    @NotNull
    public Map<String, String> getLanguage() {
        return this.language;
    }
}

