/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.addon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.client.config.addon.AddonConfig;
import su.plo.voice.client.config.VoiceClientConfig;

public final class VoiceAddonConfig
implements AddonConfig {
    private final AddonContainer addon;
    private final VoiceClientConfig.Addons.Addon config;
    private final Map<String, ConfigWidget> widgetsById = Maps.newConcurrentMap();
    private final List<ConfigWidget> widgets = Lists.newCopyOnWriteArrayList();

    @Override
    @NotNull
    public IntConfigEntry addIntSlider(@NotNull String widgetId, @NotNull McTextComponent label, @Nullable McTextComponent tooltip, @NotNull String suffix, int defaultValue, int min, int max) {
        this.checkWidgetExists(widgetId);
        IntConfigEntry configEntry = this.config.getEntry(widgetId).map(IntConfigEntry.class::cast).orElseGet(this.createEntry(widgetId, () -> new IntConfigEntry(defaultValue, min, max)));
        configEntry.setDefault(defaultValue, min, max);
        this.addWidget(widgetId, new ConfigSliderWidget(ConfigWidget.Type.INT_SLIDER, label, tooltip, configEntry, suffix));
        return configEntry;
    }

    @Override
    @NotNull
    public DoubleConfigEntry addVolumeSlider(@NotNull String widgetId, @NotNull McTextComponent label, @Nullable McTextComponent tooltip, @NotNull String suffix, double defaultValue, double min, double max) {
        this.checkWidgetExists(widgetId);
        DoubleConfigEntry configEntry = this.config.getEntry(widgetId).map(DoubleConfigEntry.class::cast).orElseGet(this.createEntry(widgetId, () -> new DoubleConfigEntry(defaultValue, min, max)));
        configEntry.setDefault(defaultValue, min, max);
        this.addWidget(widgetId, new ConfigSliderWidget(ConfigWidget.Type.VOLUME_SLIDER, label, tooltip, configEntry, suffix));
        return configEntry;
    }

    @Override
    @NotNull
    public BooleanConfigEntry addToggle(@NotNull String widgetId, @NotNull McTextComponent label, @Nullable McTextComponent tooltip, boolean defaultValue) {
        this.checkWidgetExists(widgetId);
        BooleanConfigEntry configEntry = this.config.getEntry(widgetId).map(BooleanConfigEntry.class::cast).orElseGet(this.createEntry(widgetId, () -> new BooleanConfigEntry(defaultValue)));
        configEntry.setDefault(defaultValue);
        this.addWidget(widgetId, new ConfigWidget(ConfigWidget.Type.TOGGLE, label, tooltip, configEntry));
        return configEntry;
    }

    @Override
    @NotNull
    public IntConfigEntry addDropDown(@NotNull String widgetId, @NotNull McTextComponent label, @Nullable McTextComponent tooltip, @NotNull List<String> elements, boolean elementTooltip, int defaultValueIndex) {
        this.checkWidgetExists(widgetId);
        IntConfigEntry configEntry = this.config.getEntry(widgetId).map(IntConfigEntry.class::cast).orElseGet(this.createEntry(widgetId, () -> new IntConfigEntry(defaultValueIndex, 0, 0)));
        configEntry.setDefault(defaultValueIndex);
        this.addWidget(widgetId, new ConfigDropDownWidget(label, tooltip, configEntry, elements, elementTooltip));
        return configEntry;
    }

    @Override
    public boolean removeWidget(@NotNull String translatable) {
        return Optional.ofNullable(this.widgetsById.remove(translatable)).filter(this.widgets::remove).isPresent();
    }

    @Override
    public <T extends ConfigEntry<?>> Optional<T> getWidgetConfigEntry(@NotNull String translatable) {
        ConfigWidget widget = this.widgetsById.get(translatable);
        if (widget == null) {
            return Optional.empty();
        }
        return Optional.of(widget.getConfigEntry());
    }

    @Override
    public void clear() {
        this.widgets.clear();
    }

    private void addWidget(@NotNull String id, @NotNull ConfigWidget widget) {
        this.widgets.add(widget);
        this.widgetsById.put(id, widget);
    }

    private <T extends ConfigEntry<?>> Supplier<T> createEntry(@NotNull String widgetId, @NotNull Supplier<T> supplier) {
        return () -> {
            ConfigEntry entry = (ConfigEntry)supplier.get();
            this.config.setEntry(widgetId, entry);
            return entry;
        };
    }

    private void checkWidgetExists(@NotNull String translatable) {
        if (this.widgetsById.containsKey(translatable)) {
            throw new IllegalArgumentException("Widget " + translatable + " already exist");
        }
    }

    public VoiceAddonConfig(AddonContainer addon, VoiceClientConfig.Addons.Addon config) {
        this.addon = addon;
        this.config = config;
    }

    public AddonContainer getAddon() {
        return this.addon;
    }

    public List<ConfigWidget> getWidgets() {
        return this.widgets;
    }

    public static class ConfigSliderWidget
    extends ConfigWidget {
        @NotNull
        private final String suffix;

        public ConfigSliderWidget(@NotNull ConfigWidget.Type type, @NotNull McTextComponent label, @Nullable McTextComponent tooltip, @NotNull ConfigEntry<?> configEntry, @NotNull String suffix) {
            super(type, label, tooltip, configEntry);
            this.suffix = suffix;
        }

        @NotNull
        public String getSuffix() {
            return this.suffix;
        }
    }

    public static class ConfigWidget {
        @NotNull
        private final Type type;
        @NotNull
        private final McTextComponent label;
        @Nullable
        private final McTextComponent tooltip;
        @NotNull
        private final ConfigEntry<?> configEntry;

        public ConfigWidget(@NotNull Type type, @NotNull McTextComponent label, @Nullable McTextComponent tooltip, @NotNull ConfigEntry<?> configEntry) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            if (configEntry == null) {
                throw new NullPointerException("configEntry is marked non-null but is null");
            }
            this.type = type;
            this.label = label;
            this.tooltip = tooltip;
            this.configEntry = configEntry;
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        @NotNull
        public McTextComponent getLabel() {
            return this.label;
        }

        @Nullable
        public McTextComponent getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public ConfigEntry<?> getConfigEntry() {
            return this.configEntry;
        }

        public static enum Type {
            INT_SLIDER,
            VOLUME_SLIDER,
            TOGGLE,
            DROPDOWN;

        }
    }

    public static class ConfigDropDownWidget
    extends ConfigWidget {
        @NotNull
        private final List<String> elements;
        private final boolean elementTooltip;

        public ConfigDropDownWidget(@NotNull McTextComponent label, @Nullable McTextComponent tooltip, @NotNull ConfigEntry<?> configEntry, @NotNull List<String> elements, boolean elementTooltip) {
            super(ConfigWidget.Type.DROPDOWN, label, tooltip, configEntry);
            this.elements = elements;
            this.elementTooltip = elementTooltip;
        }

        @NotNull
        public List<String> getElements() {
            return this.elements;
        }

        public boolean isElementTooltip() {
            return this.elementTooltip;
        }
    }
}

