/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.mod.entity;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_5894;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.slib.api.permission.PermissionTristate;
import su.plo.slib.api.server.McServerLib;
import su.plo.slib.api.server.entity.McServerEntity;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.slib.mod.channel.ByteArrayCodec;
import su.plo.slib.mod.channel.ByteArrayPayload;
import su.plo.slib.mod.channel.ModChannelManager;
import su.plo.slib.mod.chat.ComponentTextConverter;
import su.plo.slib.mod.entity.ModServerEntity;
import su.plo.slib.mod.extension.ScoreboardKt;
import su.plo.slib.permission.PermissionSupplier;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0019J\u001f\u0010 \u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\u0004\b\"\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0014\u0010(\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010+\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010-R\u0014\u00100\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0014\u00101\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010-R\"\u00102\u001a\u00020\u000e8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u0010*\"\u0004\b5\u00106R \u00108\u001a\b\u0012\u0004\u0012\u00020\u000e078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\u001c\u0010=\u001a\u0004\u0018\u00010<8VX\u0096\u0004\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\u00a8\u0006A"}, d2={"Lsu/plo/slib/mod/entity/ModServerPlayer;", "Lsu/plo/slib/mod/entity/ModServerEntity;", "Lnet/minecraft/class_3222;", "Lsu/plo/slib/api/server/entity/player/McServerPlayer;", "Lsu/plo/slib/api/server/McServerLib;", "minecraftServer", "Lsu/plo/slib/permission/PermissionSupplier;", "permissions", "player", "<init>", "(Lsu/plo/slib/api/server/McServerLib;Lsu/plo/slib/permission/PermissionSupplier;Lnet/minecraft/class_3222;)V", "", "canSee", "(Lsu/plo/slib/api/server/entity/player/McServerPlayer;)Z", "", "permission", "Lsu/plo/slib/api/permission/PermissionTristate;", "getPermission", "(Ljava/lang/String;)Lsu/plo/slib/api/permission/PermissionTristate;", "hasPermission", "(Ljava/lang/String;)Z", "Lsu/plo/slib/api/chat/component/McTextComponent;", "reason", "", "kick", "(Lsu/plo/slib/api/chat/component/McTextComponent;)V", "text", "sendActionBar", "sendMessage", "channel", "", "data", "sendPacket", "(Ljava/lang/String;[B)V", "addChannel", "Lsu/plo/slib/api/server/McServerLib;", "Lsu/plo/slib/permission/PermissionSupplier;", "Lsu/plo/slib/api/entity/player/McGameProfile;", "getGameProfile", "()Lsu/plo/slib/api/entity/player/McGameProfile;", "gameProfile", "getName", "()Ljava/lang/String;", "name", "isSpectator", "()Z", "isSneaking", "getHasLabelScoreboard", "hasLabelScoreboard", "isOnline", "language", "Ljava/lang/String;", "getLanguage", "setLanguage", "(Ljava/lang/String;)V", "", "registeredChannels", "Ljava/util/Set;", "getRegisteredChannels", "()Ljava/util/Set;", "Lsu/plo/slib/api/server/entity/McServerEntity;", "spectatorTarget", "Lsu/plo/slib/api/server/entity/McServerEntity;", "getSpectatorTarget", "()Lsu/plo/slib/api/server/entity/McServerEntity;", "slib-fabric-1.21"})
public final class ModServerPlayer
extends ModServerEntity<class_3222>
implements McServerPlayer {
    @NotNull
    private final McServerLib minecraftServer;
    @NotNull
    private final PermissionSupplier permissions;
    @NotNull
    private String language;
    @NotNull
    private final Set<String> registeredChannels;
    @Nullable
    private final McServerEntity spectatorTarget;

    public ModServerPlayer(@NotNull McServerLib minecraftServer, @NotNull PermissionSupplier permissions, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(minecraftServer, "minecraftServer");
        Intrinsics.checkNotNullParameter(permissions, "permissions");
        Intrinsics.checkNotNullParameter(player, "player");
        super(minecraftServer, (class_1297)player);
        this.minecraftServer = minecraftServer;
        this.permissions = permissions;
        this.language = "en_us";
        CopyOnWriteArraySet copyOnWriteArraySet = Sets.newCopyOnWriteArraySet();
        Intrinsics.checkNotNullExpressionValue(copyOnWriteArraySet, "newCopyOnWriteArraySet(...)");
        this.registeredChannels = copyOnWriteArraySet;
    }

    @Override
    @NotNull
    public McGameProfile getGameProfile() {
        UUID uUID = ((class_3222)this.getInstance()).method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUUID(...)");
        McGameProfile mcGameProfile = this.minecraftServer.getGameProfile(uUID);
        if (mcGameProfile == null) {
            throw new IllegalStateException("Game profile not found");
        }
        return mcGameProfile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((class_3222)this.getInstance()).method_7334().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    public boolean isSpectator() {
        return ((class_3222)this.getInstance()).method_7325();
    }

    @Override
    public boolean isSneaking() {
        return ((class_3222)this.getInstance()).method_21752();
    }

    @Override
    public boolean getHasLabelScoreboard() {
        class_2995 class_29952 = ((class_3222)this.getInstance()).method_51469().method_14170();
        Intrinsics.checkNotNullExpressionValue(class_29952, "getScoreboard(...)");
        return ScoreboardKt.getObjectiveBelowName((class_269)class_29952) != null;
    }

    @Override
    public boolean isOnline() {
        return !((class_3222)this.getInstance()).method_14239();
    }

    @Override
    @NotNull
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.language = string;
    }

    @NotNull
    public Set<String> getRegisteredChannels() {
        return this.registeredChannels;
    }

    @Override
    @Nullable
    public McServerEntity getSpectatorTarget() {
        if (((class_3222)this.getInstance()).method_14242() == this.getInstance()) {
            return null;
        }
        if (this.spectatorTarget == null || !((class_3222)this.getInstance()).method_14242().equals(this.spectatorTarget.getInstance())) {
            class_1297 class_12972 = ((class_3222)this.getInstance()).method_14242();
            Intrinsics.checkNotNullExpressionValue(class_12972, "getCamera(...)");
            return this.minecraftServer.getEntityByInstance(class_12972);
        }
        return this.spectatorTarget;
    }

    @Override
    public boolean canSee(@NotNull McServerPlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        class_3222 serverPlayer = (class_3222)player.getInstance();
        return serverPlayer.method_7325() ? ((class_3222)this.getInstance()).method_7325() : true;
    }

    @Override
    @NotNull
    public PermissionTristate getPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        return this.permissions.getPermission(this.getInstance(), permission);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        return this.permissions.hasPermission(this.getInstance(), permission);
    }

    @Override
    public void kick(@NotNull McTextComponent reason) {
        Intrinsics.checkNotNullParameter(reason, "reason");
        String json = this.minecraftServer.getTextConverter().convertToJson(this, reason);
        class_2561 component = ComponentTextConverter.INSTANCE.convertFromJson(json);
        ((class_3222)this.getInstance()).field_13987.method_52396(component);
    }

    @Override
    public void sendActionBar(@NotNull McTextComponent text) {
        Intrinsics.checkNotNullParameter(text, "text");
        String json = this.minecraftServer.getTextConverter().convertToJson(this, text);
        class_2561 component = ComponentTextConverter.INSTANCE.convertFromJson(json);
        ((class_3222)this.getInstance()).field_13987.method_14364((class_2596)new class_5894(component));
    }

    @Override
    public void sendMessage(@NotNull McTextComponent text) {
        Intrinsics.checkNotNullParameter(text, "text");
        String json = this.minecraftServer.getTextConverter().convertToJson(this, text);
        class_2561 component = ComponentTextConverter.INSTANCE.convertFromJson(json);
        ((class_3222)this.getInstance()).method_43496(component);
    }

    @Override
    public void sendPacket(@NotNull String channel, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(data, "data");
        class_2960 class_29602 = class_2960.method_12829((String)channel);
        if (class_29602 == null) {
            throw new IllegalArgumentException("Invalid channel key");
        }
        class_2960 channelKey = class_29602;
        ByteArrayCodec codec = ModChannelManager.Companion.getOrRegisterCodec(channelKey);
        ServerPlayNetworking.send((class_3222)((class_3222)this.getInstance()), (class_8710)new ByteArrayPayload(codec.getType(), data));
    }

    public final boolean addChannel(@NotNull String channel) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        return this.getRegisteredChannels().add(channel);
    }
}

