/*
 * Decompiled with CFR 0.152.
 */
package com.plasmoverse.opus;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public final class OpusLibrary {
    private static boolean LOADED;

    public static void load() throws IOException {
        if (LOADED) {
            return;
        }
        File temporaryDir = Files.createTempDirectory("opus-jni-rust", new FileAttribute[0]).toFile();
        temporaryDir.deleteOnExit();
        String libraryName = OpusLibrary.getPlatformLibraryFileName("opus_jni_rust");
        String platformFolder = OpusLibrary.getPlatformFolderName();
        String nativeLibraryPath = String.format("/natives/%s/%s", platformFolder, libraryName);
        InputStream source2 = OpusLibrary.class.getResourceAsStream(nativeLibraryPath);
        if (source2 == null) {
            throw new IOException("Couldn't find the native library: " + nativeLibraryPath);
        }
        Path destination = temporaryDir.toPath().resolve(libraryName);
        try {
            Files.copy(source2, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        System.load(destination.toFile().getAbsolutePath());
        LOADED = true;
    }

    private static String getPlatformFolderName() {
        return String.format("%s-%s", OpusLibrary.getPlatformName(), OpusLibrary.getPlatformArch());
    }

    private static String getPlatformName() {
        String systemName = System.getProperty("os.name").toLowerCase();
        if (systemName.contains("nux") || systemName.contains("nix")) {
            return "linux";
        }
        if (systemName.contains("mac")) {
            return "mac";
        }
        if (systemName.contains("windows")) {
            return "win";
        }
        throw new IllegalStateException("System is not supported: " + systemName);
    }

    private static String getPlatformArch() {
        String systemArch = System.getProperty("os.arch").toLowerCase();
        boolean is64bit = systemArch.contains("64");
        boolean isArm = systemArch.startsWith("aarch");
        if (isArm) {
            return "aarch64";
        }
        if (is64bit) {
            return "x86_64";
        }
        return "x86";
    }

    private static String getPlatformLibraryFileName(String library) {
        String systemName = System.getProperty("os.name").toLowerCase();
        if (systemName.contains("nux") || systemName.contains("nix")) {
            return "lib" + library + ".so";
        }
        if (systemName.contains("mac")) {
            return "lib" + library + ".dylib";
        }
        if (systemName.contains("windows")) {
            return library + ".dll";
        }
        throw new IllegalStateException("System is not supported: " + systemName);
    }

    private OpusLibrary() {
    }
}

