/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.fabricskyboxes_interop.sky;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.util.Utils;
import io.github.amerebagatelle.fabricskyboxes.util.object.Fade;
import io.github.amerebagatelle.fabricskyboxes.util.object.Loop;
import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import io.github.amerebagatelle.fabricskyboxes.util.object.Weather;
import java.util.List;
import me.flashyreese.mods.fabricskyboxes_interop.sky.OptiFineBlend;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_7924;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class OptiFineSkyLayer {
    private static final Codec<Vector3f> VEC_3_F = Codec.FLOAT.listOf().comapFlatMap(list -> {
        if (list.size() < 3) {
            return DataResult.error(() -> "Incomplete number of elements in vector");
        }
        return DataResult.success((Object)new Vector3f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue()));
    }, vec -> ImmutableList.of((Object)Float.valueOf(vec.x()), (Object)Float.valueOf(vec.y()), (Object)Float.valueOf(vec.z())));
    private static final Fade OPTIFINE_FADE = new Fade(0, 0, 0, 0, true);
    public static final Codec<OptiFineSkyLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("source").forGetter(OptiFineSkyLayer::getSource), (App)Codec.BOOL.optionalFieldOf("biomeInclusion", (Object)true).forGetter(OptiFineSkyLayer::isBiomeInclusion), (App)class_2960.field_25139.listOf().optionalFieldOf("biomes", (Object)ImmutableList.of()).forGetter(OptiFineSkyLayer::getBiomes), (App)MinMaxEntry.CODEC.listOf().optionalFieldOf("heights", (Object)ImmutableList.of()).forGetter(OptiFineSkyLayer::getHeights), (App)OptiFineBlend.CODEC.optionalFieldOf("blend", (Object)OptiFineBlend.ADD).forGetter(OptiFineSkyLayer::getBlend), (App)Fade.CODEC.optionalFieldOf("fade", (Object)OPTIFINE_FADE).forGetter(OptiFineSkyLayer::getFade), (App)Codec.BOOL.optionalFieldOf("rotate", (Object)false).forGetter(OptiFineSkyLayer::isRotate), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(OptiFineSkyLayer::getSpeed), (App)VEC_3_F.optionalFieldOf("axis", (Object)new Vector3f(1.0f, 0.0f, 0.0f)).forGetter(OptiFineSkyLayer::getAxis), (App)Loop.CODEC.optionalFieldOf("loop", (Object)Loop.DEFAULT).forGetter(OptiFineSkyLayer::getLoop), (App)Codec.FLOAT.optionalFieldOf("transition", (Object)Float.valueOf(1.0f)).forGetter(OptiFineSkyLayer::getTransition), (App)Weather.CODEC.listOf().optionalFieldOf("weathers", (Object)ImmutableList.of((Object)Weather.CLEAR)).forGetter(OptiFineSkyLayer::getWeathers)).apply((Applicative)instance, OptiFineSkyLayer::new));
    private final class_2960 source;
    private final boolean biomeInclusion;
    private final List<class_2960> biomes;
    private final List<MinMaxEntry> heights;
    private final OptiFineBlend blend;
    private final Fade fade;
    private final boolean rotate;
    private final float speed;
    private final Vector3f axis;
    private final Loop loop;
    private final float transition;
    private final List<Weather> weathers;
    public float conditionAlpha = -1.0f;

    public OptiFineSkyLayer(class_2960 source, boolean biomeInclusion, List<class_2960> biomes, List<MinMaxEntry> heights, OptiFineBlend blend, Fade fade, boolean rotate, float speed, Vector3f axis, Loop loop, float transition, List<Weather> weathers) {
        this.source = source;
        this.biomeInclusion = biomeInclusion;
        this.biomes = biomes;
        this.heights = heights;
        this.blend = blend;
        this.fade = fade;
        this.rotate = rotate;
        this.speed = speed;
        this.axis = axis;
        this.loop = loop;
        this.transition = transition;
        this.weathers = weathers;
    }

    public void tick(class_1937 world) {
        this.conditionAlpha = this.getPositionBrightness(world);
    }

    public void render(class_1937 world, class_4587 matrixStack, int timeOfDay, float skyAngle, float rainGradient, float thunderGradient) {
        float fadeAlpha;
        float weatherAlpha = this.getWeatherAlpha(rainGradient, thunderGradient);
        float finalAlpha = class_3532.method_15363((float)(this.conditionAlpha * weatherAlpha * (fadeAlpha = this.getFadeAlpha(timeOfDay))), (float)0.0f, (float)1.0f);
        if (!(finalAlpha < 1.0E-4f)) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.source);
            this.blend.getBlendFunc().accept(Float.valueOf(finalAlpha));
            matrixStack.method_22903();
            if (this.rotate) {
                float angle = this.getAngle(world, skyAngle);
                Quaternionf rotation = new Quaternionf();
                rotation.rotationAxis(angle, (Vector3fc)this.axis);
                matrixStack.method_22907(rotation);
            }
            class_289 tessellator = class_289.method_1348();
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
            this.renderSide(matrixStack, tessellator, 4);
            matrixStack.method_22903();
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            this.renderSide(matrixStack, tessellator, 1);
            matrixStack.method_22909();
            matrixStack.method_22903();
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
            this.renderSide(matrixStack, tessellator, 0);
            matrixStack.method_22909();
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            this.renderSide(matrixStack, tessellator, 5);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            this.renderSide(matrixStack, tessellator, 2);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            this.renderSide(matrixStack, tessellator, 3);
            matrixStack.method_22909();
        }
    }

    private void renderSide(class_4587 matrixStackIn, class_289 tess, int side) {
        float f = (float)(side % 3) / 3.0f;
        float f1 = (float)(side / 3) / 2.0f;
        Matrix4f matrix4f = matrixStackIn.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferbuilder = tess.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        this.addVertex(matrix4f, bufferbuilder, -100.0f, -100.0f, -100.0f, f, f1);
        this.addVertex(matrix4f, bufferbuilder, -100.0f, -100.0f, 100.0f, f, f1 + 0.5f);
        this.addVertex(matrix4f, bufferbuilder, 100.0f, -100.0f, 100.0f, f + 0.33333334f, f1 + 0.5f);
        this.addVertex(matrix4f, bufferbuilder, 100.0f, -100.0f, -100.0f, f + 0.33333334f, f1);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
    }

    private void addVertex(Matrix4f matrix4f, class_287 buffer, float x, float y, float z, float u, float v) {
        Vector4f vector4f = matrix4f.transform(new Vector4f(x, y, z, 1.0f));
        buffer.method_22912(vector4f.x, vector4f.y, vector4f.z).method_22913(u, v);
    }

    private float getAngle(class_1937 world, float skyAngle) {
        float angleDayStart = 0.0f;
        if (this.speed != (float)Math.round(this.speed)) {
            long currentWorldDay = (world.method_8532() + 18000L) / 24000L;
            double anglePerDay = this.speed % 1.0f;
            double currentAngle = (double)currentWorldDay * anglePerDay;
            angleDayStart = (float)(currentAngle % 1.0);
        }
        return -360.0f * (angleDayStart + skyAngle * this.speed) * (float)Math.PI / 180.0f;
    }

    private boolean getConditionCheck(class_1937 world) {
        class_310 minecraftClient = class_310.method_1551();
        class_1297 cameraEntity = minecraftClient.method_1560();
        if (cameraEntity == null) {
            return false;
        }
        class_2338 entityPos = cameraEntity.method_24515();
        if (!this.biomes.isEmpty()) {
            class_1959 currentBiome = (class_1959)world.method_23753(entityPos).comp_349();
            if (currentBiome == null) {
                return false;
            }
            if (!this.biomeInclusion || !this.biomes.contains(world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)currentBiome))) {
                return false;
            }
        }
        return this.heights == null || Utils.checkRanges((double)entityPos.method_10264(), this.heights);
    }

    private float getPositionBrightness(class_1937 world) {
        if (this.biomes.isEmpty() && this.heights.isEmpty()) {
            return 1.0f;
        }
        if (this.conditionAlpha == -1.0f) {
            boolean conditionCheck = this.getConditionCheck(world);
            return conditionCheck ? 1.0f : 0.0f;
        }
        return Utils.calculateConditionAlphaValue((float)1.0f, (float)0.0f, (float)this.conditionAlpha, (int)((int)(this.transition * 20.0f)), (boolean)this.getConditionCheck(world));
    }

    private float getWeatherAlpha(float rainStrength, float thunderStrength) {
        float f = 1.0f - rainStrength;
        float f1 = rainStrength - thunderStrength;
        float weatherAlpha = 0.0f;
        if (this.weathers.contains(Weather.CLEAR)) {
            weatherAlpha += f;
        }
        if (this.weathers.contains(Weather.RAIN)) {
            weatherAlpha += f1;
        }
        if (this.weathers.contains(Weather.THUNDER)) {
            weatherAlpha += thunderStrength;
        }
        return class_3532.method_15363((float)weatherAlpha, (float)0.0f, (float)1.0f);
    }

    private float getFadeAlpha(int timeOfDay) {
        if (!this.fade.isAlwaysOn()) {
            return Utils.calculateFadeAlphaValue((float)1.0f, (float)0.0f, (int)timeOfDay, (int)this.fade.getStartFadeIn(), (int)this.fade.getEndFadeIn(), (int)this.fade.getStartFadeOut(), (int)this.fade.getEndFadeOut());
        }
        return 1.0f;
    }

    public boolean isActive(int timeOfDay) {
        if (!this.fade.isAlwaysOn() && Utils.isInTimeInterval((int)timeOfDay, (int)this.fade.getEndFadeOut(), (int)this.fade.getStartFadeIn())) {
            return false;
        }
        if (this.loop.getRanges() != null) {
            long adjustedTime;
            for (adjustedTime = (long)timeOfDay - (long)this.fade.getStartFadeIn(); adjustedTime < 0L; adjustedTime += 24000L * (long)((int)this.loop.getDays())) {
            }
            int daysPassed = (int)(adjustedTime / 24000L);
            int currentDay = daysPassed % (int)this.loop.getDays();
            return Utils.checkRanges((double)currentDay, (List)this.loop.getRanges());
        }
        return true;
    }

    public class_2960 getSource() {
        return this.source;
    }

    public boolean isBiomeInclusion() {
        return this.biomeInclusion;
    }

    public List<class_2960> getBiomes() {
        return this.biomes;
    }

    public List<MinMaxEntry> getHeights() {
        return this.heights;
    }

    public OptiFineBlend getBlend() {
        return this.blend;
    }

    public Fade getFade() {
        return this.fade;
    }

    public boolean isRotate() {
        return this.rotate;
    }

    public float getSpeed() {
        return this.speed;
    }

    public Vector3f getAxis() {
        return this.axis;
    }

    public Loop getLoop() {
        return this.loop;
    }

    public float getTransition() {
        return this.transition;
    }

    public List<Weather> getWeathers() {
        return this.weathers;
    }

    public void setConditionAlpha(float conditionAlpha) {
        this.conditionAlpha = conditionAlpha;
    }
}

