/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.fabricskyboxes_interop.sky;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public enum OptiFineBlend {
    ALPHA("alpha", alpha -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
    }),
    ADD("add", alpha -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
    }),
    SUBTRACT("subtract", alpha -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
    }),
    MULTIPLY("multiply", alpha -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue());
    }),
    DODGE("dodge", alpha -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
    }),
    BURN("burn", alpha -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
    }),
    SCREEN("screen", alpha -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
    }),
    OVERLAY("overlay", alpha -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.SRC_COLOR);
        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
    }),
    REPLACE("replace", alpha -> {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
    });

    private static final Map<String, OptiFineBlend> VALUES;
    public static final Codec<OptiFineBlend> CODEC;
    private final String name;
    private final Consumer<Float> blendFunc;

    private OptiFineBlend(String name, Consumer<Float> blendFunc) {
        this.name = name;
        this.blendFunc = blendFunc;
    }

    public String getName() {
        return this.name;
    }

    public Consumer<Float> getBlendFunc() {
        return this.blendFunc;
    }

    public static OptiFineBlend fromString(String name) {
        return Objects.requireNonNull(VALUES.get(name));
    }

    public String toString() {
        return this.name;
    }

    static {
        CODEC = Codec.STRING.xmap(OptiFineBlend::fromString, OptiFineBlend::toString);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (OptiFineBlend value : OptiFineBlend.values()) {
            builder.put((Object)value.name, (Object)value);
        }
        VALUES = builder.build();
    }
}

