/*
 * Decompiled with CFR 0.152.
 */
package prograde.taskbariconchanger;

import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import prograde.taskbariconchanger.TaskbarIconChanger;

@Environment(value=EnvType.CLIENT)
public class IconLoader {
    public static void setWindowIcon(File inputIconFile, class_310 mcInstance) throws IOException {
        ArrayList<InputStream> iconsList = new ArrayList<InputStream>();
        ArrayList bufferedImageList = new ArrayList(0);
        String inputIconFilenameAndExt = inputIconFile.getName().toLowerCase();
        if (inputIconFilenameAndExt.endsWith(".png")) {
            iconsList.add(new FileInputStream(inputIconFile));
        }
        TaskbarIconChanger.LOGGER.debug("Icon file: \"" + inputIconFilenameAndExt + "\"");
        if (inputIconFilenameAndExt.endsWith(".ico") || inputIconFilenameAndExt.endsWith(".icns")) {
            for (BufferedImage bufferedImage : bufferedImageList) {
                TaskbarIconChanger.LOGGER.debug("---");
                TaskbarIconChanger.LOGGER.debug("Type: " + bufferedImage.getType());
                TaskbarIconChanger.LOGGER.debug("Width: " + bufferedImage.getWidth());
                TaskbarIconChanger.LOGGER.debug("Height: " + bufferedImage.getHeight());
                TaskbarIconChanger.LOGGER.debug("Transparency: " + bufferedImage.getTransparency());
                if (bufferedImage.getType() == 2) {
                    if (inputIconFilenameAndExt.endsWith(".icns")) {
                        if (bufferedImage.getWidth() <= 48) {
                            iconsList.add(IconLoader.convertToInputStream(bufferedImage));
                            TaskbarIconChanger.LOGGER.debug("Added embedded image");
                            continue;
                        }
                        TaskbarIconChanger.LOGGER.debug("Skipped embedded image");
                        continue;
                    }
                    iconsList.add(IconLoader.convertToInputStream(bufferedImage));
                    TaskbarIconChanger.LOGGER.debug("Added embedded image");
                    continue;
                }
                TaskbarIconChanger.LOGGER.debug("Skipped embedded image");
            }
        }
        TaskbarIconChanger.LOGGER.debug("Final iconsList size: " + iconsList.size());
        GLFWImage.Buffer buffer = IconLoader.loadIconsIntoBuffer(iconsList, mcInstance);
        GLFW.glfwSetWindowIcon((long)mcInstance.method_22683().method_4490(), (GLFWImage.Buffer)buffer);
    }

    public static GLFWImage.Buffer loadIconsIntoBuffer(List<InputStream> iconsList, class_310 mcInstance) throws IOException {
        return IconLoader.loadIconsIntoBuffer(iconsList, mcInstance, 1);
    }

    public static GLFWImage.Buffer loadIconsIntoBuffer(List<InputStream> iconsList, class_310 mcInstance, int attempt) throws IOException {
        MemoryStack memoryStack = MemoryStack.stackPush();
        GLFWImage.Buffer buffer = GLFWImage.malloc((int)iconsList.size(), (MemoryStack)memoryStack);
        IntBuffer intBufferX = memoryStack.mallocInt(1);
        IntBuffer intBufferY = memoryStack.mallocInt(1);
        IntBuffer intBufferChannels = memoryStack.mallocInt(1);
        short iconCounter = 0;
        int errorCounter = 0;
        ArrayList<InputStream> newIconsList = new ArrayList<InputStream>();
        for (InputStream inStream : iconsList) {
            ByteBuffer byteBuffer;
            try {
                byteBuffer = IconLoader.readIconPixels(inStream, intBufferX, intBufferY, intBufferChannels);
                if (byteBuffer == null) {
                    throw new IOException("byteBuffer is null");
                }
            }
            catch (IOException e) {
                TaskbarIconChanger.LOGGER.debug("Unable to load image #" + iconCounter + " inside iconsList, skipping...");
                errorCounter = (short)(errorCounter + 1);
                continue;
            }
            buffer.position((int)iconCounter);
            buffer.width(intBufferX.get(0));
            buffer.height(intBufferY.get(0));
            buffer.pixels(byteBuffer);
            iconCounter = (short)(iconCounter + 1);
            newIconsList.add(inStream);
        }
        if (errorCounter == iconsList.size()) {
            throw new IOException("Unable to load icon(s): Failed to load all embedded images");
        }
        if (errorCounter > 0) {
            if (attempt > 2) {
                throw new IOException("Unable to load icon(s): Too many failed attempts");
            }
            return IconLoader.loadIconsIntoBuffer(newIconsList, mcInstance, attempt + 1);
        }
        buffer.position(0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer readIconPixels(InputStream pTextureStream, IntBuffer pX, IntBuffer pY, IntBuffer pChannelInFile) throws IOException {
        ByteBuffer bytebuffer1;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource((InputStream)pTextureStream);
            bytebuffer.rewind();
            bytebuffer1 = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)pX, (IntBuffer)pY, (IntBuffer)pChannelInFile, (int)0);
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return bytebuffer1;
    }

    public static ByteArrayInputStream convertToInputStream(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        ImageIO.write((RenderedImage)bufferedImage, "png", output);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(output.toByteArray(), 0, output.size());
        bufferedImage.flush();
        return inputStream;
    }
}

