/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.OptionalFieldCodec;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;

public class LenientCodecWithLog<A>
extends OptionalFieldCodec<A> {
    private final String name;
    private final Codec<A> elementCodec;

    private LenientCodecWithLog(String name, Codec<A> elementCodec) {
        super(name, elementCodec, true);
        this.name = name;
        this.elementCodec = elementCodec;
    }

    public static <A> MapCodec<A> of(Codec<A> elementCodec, String name, A defaultValue) {
        return LenientCodecWithLog.of(elementCodec, name).xmap(o -> o.orElse(defaultValue), a -> Objects.equals(a, defaultValue) ? Optional.empty() : Optional.of(a));
    }

    public static <A> MapCodec<Optional<A>> of(Codec<A> elementCodec, String name) {
        return new LenientCodecWithLog<A>(name, elementCodec);
    }

    public <T> DataResult<Optional<A>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(Optional.empty());
        }
        DataResult parsed = this.elementCodec.parse(ops, value);
        if (parsed.isError()) {
            Polytone.LOGGER.error("Failed to parse {}: {}. Skipping", (Object)this.name, (Object)parsed.error());
            return DataResult.success(Optional.empty());
        }
        return parsed.map(Optional::of).setPartial((Object)parsed.resultOrPartial());
    }
}

