/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.slotify.IntRange;
import net.minecraft.class_2561;
import net.minecraft.class_339;

public record WidgetModifier(int xOffset, int yOffset, int width, Optional<String> message, Optional<IntRange> targetX, Optional<IntRange> targetY, Optional<IntRange> targetW, Optional<IntRange> targetH, Optional<String> targetMessage, Optional<String> targetClass) {
    public static final Codec<WidgetModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(WidgetModifier::xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(WidgetModifier::yOffset), (App)Codec.INT.optionalFieldOf("width_increment", (Object)0).forGetter(WidgetModifier::width), (App)Codec.STRING.optionalFieldOf("message").forGetter(WidgetModifier::message), (App)IntRange.CODEC.optionalFieldOf("target_x").forGetter(WidgetModifier::targetX), (App)IntRange.CODEC.optionalFieldOf("target_y").forGetter(WidgetModifier::targetY), (App)IntRange.CODEC.optionalFieldOf("target_width").forGetter(WidgetModifier::targetY), (App)IntRange.CODEC.optionalFieldOf("target_height").forGetter(WidgetModifier::targetY), (App)Codec.STRING.optionalFieldOf("target_message").forGetter(WidgetModifier::targetMessage), (App)Codec.STRING.xmap(PlatStuff::maybeRemapName, PlatStuff::maybeRemapName).optionalFieldOf("target_class_name").forGetter(WidgetModifier::targetClass)).apply((Applicative)i, WidgetModifier::new)).comapFlatMap(o -> {
        if (o.targetW.isEmpty() && o.targetH.isEmpty() && o.targetX.isEmpty() && o.targetClass.isEmpty() && o.targetY.isEmpty() && o.targetMessage.isEmpty()) {
            return DataResult.error(() -> "Widget modifier must have at least one target");
        }
        return DataResult.success((Object)o);
    }, Function.identity());

    public void maybeModify(class_339 widget) {
        if (this.targetX.isPresent() && !this.targetX.get().has(widget.method_46426())) {
            return;
        }
        if (this.targetY.isPresent() && !this.targetY.get().has(widget.method_46427())) {
            return;
        }
        if (this.targetH.isPresent() && !this.targetH.get().has(widget.method_25364())) {
            return;
        }
        if (this.targetW.isPresent() && !this.targetW.get().has(widget.method_25368())) {
            return;
        }
        if (this.targetMessage.isPresent() && !widget.method_25369().getString().equals(this.targetMessage.get())) {
            return;
        }
        if (this.targetClass.isPresent()) {
            String name = this.targetClass.get();
            if (!widget.getClass().getSimpleName().equals(name) && !widget.getClass().getName().equals(name)) {
                return;
            }
        }
        widget.method_46421(widget.method_46426() + this.xOffset);
        widget.method_46419(widget.method_46427() + this.yOffset);
        widget.method_25358(widget.method_25368() + this.width);
        this.message.ifPresent(s -> widget.method_25355((class_2561)class_2561.method_43471((String)s)));
    }
}

