/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.utils.LenientUnboundedMapCodec;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BiomeCompoundColorGetter
implements IColorGetter {
    public static final Codec<BiomeCompoundColorGetter> CODEC = RecordCodecBuilder.create(i -> i.group((App)Colormap.REFERENCE_OR_EXPRESSION.fieldOf("default").forGetter(c -> c.defaultGetter), (App)new LenientUnboundedMapCodec(class_6899.method_40400((class_5321)class_7924.field_41236), Colormap.REFERENCE_OR_EXPRESSION).fieldOf("biomes").forGetter(c -> c.holderMap)).apply((Applicative)i, BiomeCompoundColorGetter::new)).validate(c -> {
        if (c.getters.isEmpty()) {
            return DataResult.error(() -> "Must have at least 1 tint getter");
        }
        for (IColorGetter a : c.getters.values()) {
            if (!a.needsToFillTexture()) continue;
            return DataResult.error(() -> "Biome compound colormap only works on BY_REFERENCE colormaps defined in the colormap folder");
        }
        if (c.defaultGetter.needsToFillTexture()) {
            return DataResult.error(() -> "Biome compound colormap only works on BY_REFERENCE colormaps defined in the colormap folder");
        }
        return DataResult.success((Object)c);
    });
    private final Map<class_1959, IColorGetter> getters = new HashMap<class_1959, IColorGetter>();
    private final Map<class_6880<class_1959>, IColorGetter> holderMap;
    private final IColorGetter defaultGetter;

    public BiomeCompoundColorGetter(IColorGetter defaultGetter, Map<class_6880<class_1959>, IColorGetter> map) {
        for (Map.Entry<class_6880<class_1959>, IColorGetter> e : map.entrySet()) {
            this.getters.put((class_1959)e.getKey().comp_349(), e.getValue());
        }
        this.holderMap = map;
        this.defaultGetter = defaultGetter;
    }

    @Override
    public boolean needsToFillTexture() {
        return false;
    }

    public int getColor(class_2680 blockState, @Nullable class_1920 level, @Nullable class_2338 pos, int i) {
        class_4538 l;
        class_1959 biome;
        IColorGetter g;
        if (level instanceof class_4538 && (g = this.getters.get(biome = (class_1959)(l = (class_4538)level).method_23753(pos).comp_349())) != null) {
            return g.getColor(blockState, level, pos, i);
        }
        return this.defaultGetter.getColor(blockState, level, pos, i);
    }

    public int getColor(class_1799 itemStack, int i) {
        return this.defaultGetter.getColor(itemStack, i);
    }

    @Override
    public IColorGetter makeConcurrent() {
        HashMap<class_6880<class_1959>, IColorGetter> map = new HashMap<class_6880<class_1959>, IColorGetter>();
        for (Map.Entry<class_6880<class_1959>, IColorGetter> e : this.holderMap.entrySet()) {
            map.put(e.getKey(), e.getValue().makeConcurrent());
        }
        return new BiomeCompoundColorGetter(this.defaultGetter.makeConcurrent(), map);
    }
}

