/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.PatPat;
import net.lopymine.patpat.common.config.PatPatConfigManager;
import net.lopymine.patpat.utils.PlayerListConfigUtils;

public class PatPatServerPlayerListConfig {
    private static final String FILENAME = "player-list.txt";
    private static final PatLogger LOGGER = PatPat.LOGGER.extend("PlayerListConfig");
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("player-list.txt").toFile();
    private static PatPatServerPlayerListConfig INSTANCE;
    private final Map<UUID, String> map = new HashMap<UUID, String>();

    public static PatPatServerPlayerListConfig getInstance() {
        if (INSTANCE == null) {
            return PatPatServerPlayerListConfig.reload();
        }
        return INSTANCE;
    }

    public static PatPatServerPlayerListConfig reload() {
        PatPatServerPlayerListConfig config = new PatPatServerPlayerListConfig();
        PlayerListConfigUtils.read(CONFIG_FILE, LOGGER, config.getMap());
        INSTANCE = config;
        return INSTANCE;
    }

    public boolean contains(UUID uuid) {
        return this.map.containsKey(uuid);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        this.save(CONFIG_FILE);
    }

    public void save(File folder) {
        PlayerListConfigUtils.save(folder, LOGGER, this.map);
    }

    public Map<UUID, String> getMap() {
        return this.map;
    }
}

