/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.command.ratelimit.set;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.lopymine.patpat.common.config.time.Time;
import net.lopymine.patpat.extension.CommandExtension;
import net.lopymine.patpat.server.config.PatPatServerConfig;
import net.lopymine.patpat.server.config.sub.PatPatServerRateLimitConfig;
import net.lopymine.patpat.server.ratelimit.PatPatServerRateLimitManager;
import net.lopymine.patpat.utils.CommandText;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class PatPatServerRateLimitIntervalCommand {
    private PatPatServerRateLimitIntervalCommand() {
        throw new IllegalStateException("Command class");
    }

    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"interval").requires(context -> CommandExtension.hasPatPatPermission(context, "ratelimit.set.interval"))).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.word()).executes(PatPatServerRateLimitIntervalCommand::set));
    }

    public static int set(CommandContext<class_2168> context) {
        PatPatServerConfig config = PatPatServerConfig.getInstance();
        PatPatServerRateLimitConfig rateLimitConfig = config.getRateLimitConfig();
        String value = StringArgumentType.getString(context, (String)"value");
        try {
            Time time = Time.of(value);
            if (time.getValue() < 1) {
                class_5250 text = CommandText.goldenArgs("error.time_less_than", time, "1sec").finish();
                CommandExtension.sendMsg(context, (class_2561)text);
                return 0;
            }
            rateLimitConfig.setTokenIncrementInterval(time);
            config.saveAsync();
            PatPatServerRateLimitManager.reloadTask();
            class_5250 text = CommandText.goldenArgs("ratelimit.set.interval", time).finish();
            CommandExtension.sendMsg(context, (class_2561)text);
        }
        catch (IllegalArgumentException ignored) {
            class_5250 text = CommandText.goldenArgs("ratelimit.set.interval.not_time", value).finish();
            CommandExtension.sendMsg(context, (class_2561)text);
            return 0;
        }
        return 1;
    }
}

