/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.dedicated;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.lopymine.patpat.dedicated.PatPatDedicatedServer;
import net.minecraft.class_2477;
import org.jetbrains.annotations.Nullable;

public class PatPatDedicatedServerTranslationManager {
    private static final Map<String, String> EN_US = new HashMap<String, String>();

    public static void reload() {
        EN_US.clear();
        ModContainer modContainer = PatPatDedicatedServerTranslationManager.getModContainer();
        if (modContainer == null) {
            PatPatDedicatedServer.LOGGER.error("Failed to get PatPat language files for server-side, because PatPat mod container doesn't exits!", new Object[0]);
            return;
        }
        Optional optional = modContainer.findPath("assets/%s/lang/en_us.json".formatted("patpat"));
        if (optional.isEmpty()) {
            PatPatDedicatedServer.LOGGER.error("Failed to find PatPat language files for server-side!", new Object[0]);
            return;
        }
        try (InputStream stream = Files.newInputStream((Path)optional.get(), new OpenOption[0]);){
            class_2477.method_29425((InputStream)stream, EN_US::put);
        }
        catch (Exception e) {
            PatPatDedicatedServer.LOGGER.error("Unexpected error when parsing PatPat language file: ", e);
        }
        PatPatDedicatedServer.LOGGER.info("Successfully loaded PatPat language files!", new Object[0]);
    }

    public static String getOrDefault(String key) {
        return EN_US.getOrDefault(key, key);
    }

    @Nullable
    private static ModContainer getModContainer() {
        try {
            return (ModContainer)FabricLoader.getInstance().getModContainer("patpat").orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }
}

