/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.utils.VersionedThings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityConfig {
    public static final Codec<EntityConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(EntityConfig::getEntityId), (App)Codec.STRING.optionalFieldOf("name").forGetter(EntityConfig::getOptionalEntityName), (App)VersionedThings.UUID_CODEC.optionalFieldOf("uuid").forGetter(EntityConfig::getOptionalEntityUuid), (App)PlayerConfig.CODEC.listOf().optionalFieldOf("from").forGetter(EntityConfig::getOptionalFrom)).apply((Applicative)instance, EntityConfig::new));
    public static final Codec<EntityConfig> STRINGED_CODEC = Codec.either((Codec)Codec.STRING, CODEC).xmap(either -> {
        if (either.left().isPresent()) {
            return EntityConfig.of((String)either.left().get());
        }
        if (either.right().isPresent()) {
            return (EntityConfig)either.right().get();
        }
        return null;
    }, entityData -> {
        String id = entityData.getEntityId();
        String name = entityData.getEntityName();
        UUID uuid = entityData.getEntityUuid();
        List<PlayerConfig> from = entityData.getEntitiesFrom();
        if (name == null && uuid == null && from == null) {
            return Either.left((Object)id);
        }
        return Either.right((Object)entityData);
    });
    public static final Codec<List<EntityConfig>> LISTED_CODEC = Codec.either((Codec)STRINGED_CODEC.listOf(), STRINGED_CODEC).xmap(either -> {
        if (either.left().isPresent()) {
            return (List)either.left().get();
        }
        if (either.right().isPresent()) {
            return new ArrayList<EntityConfig>(List.of((EntityConfig)either.right().get()));
        }
        return new ArrayList();
    }, list -> {
        if (list.size() == 1) {
            return Either.right((Object)((EntityConfig)list.get(0)));
        }
        return Either.left((Object)list);
    });
    @NotNull
    private final String entityId;
    @Nullable
    private final String entityName;
    @Nullable
    private final UUID entityUuid;
    @Nullable
    private final List<PlayerConfig> entitiesFrom;

    public EntityConfig(@NotNull String entityId, Optional<String> entityName, Optional<UUID> entityUuid, Optional<List<PlayerConfig>> entitiesFrom) {
        this.entityId = entityId;
        this.entityName = entityName.orElse(null);
        this.entityUuid = entityUuid.orElse(null);
        this.entitiesFrom = entitiesFrom.orElse(null);
    }

    public static EntityConfig of(@NotNull String entityId) {
        return new EntityConfig(entityId, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public boolean is(@NotNull String entityTypeId, @Nullable String entityName, @Nullable UUID entityUuid) {
        return !(!entityTypeId.equalsIgnoreCase(this.entityId) || this.entityName != null && !Objects.equals(this.entityName, entityName) || this.entityUuid != null && !Objects.equals(this.entityUuid, entityUuid));
    }

    private Optional<String> getOptionalEntityName() {
        return Optional.ofNullable(this.entityName);
    }

    private Optional<UUID> getOptionalEntityUuid() {
        return Optional.ofNullable(this.entityUuid);
    }

    private Optional<List<PlayerConfig>> getOptionalFrom() {
        return Optional.ofNullable(this.entitiesFrom);
    }

    public String toString() {
        return "EntityConfig{entityId='" + this.entityId + "', entityName='" + this.entityName + "', entityUuid=" + String.valueOf(this.entityUuid) + ", from=" + String.valueOf(this.entitiesFrom) + "}";
    }

    @NotNull
    public String getEntityId() {
        return this.entityId;
    }

    @Nullable
    public String getEntityName() {
        return this.entityName;
    }

    @Nullable
    public UUID getEntityUuid() {
        return this.entityUuid;
    }

    @Nullable
    public List<PlayerConfig> getEntitiesFrom() {
        return this.entitiesFrom;
    }
}

