/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.PatPatClientConfig;
import net.lopymine.patpat.common.config.PatPatConfigManager;
import net.lopymine.patpat.utils.CodecUtils;
import net.lopymine.patpat.utils.ConfigUtils;
import net.lopymine.patpat.utils.VersionedThings;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

public class PatPatStatsConfig {
    public static final Codec<PatPatStatsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("totalPatsCounter", new PatsCounter(0L), PatsCounter.CODEC, PatPatStatsConfig::getTotalPatsCounter), CodecUtils.option("entities", new HashMap(), Codec.STRING, PatsCounter.CODEC, PatPatStatsConfig::getPatsPerEntity)).apply((Applicative)instance, PatPatStatsConfig::new));
    private static final PatLogger LOGGER = PatPatClient.LOGGER.extend("StatsConfig");
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("patpat-client-stats.json5").toFile();
    private static PatPatStatsConfig instance;
    private PatsCounter totalPatsCounter;
    private HashMap<String, PatsCounter> patsPerEntity;

    private PatPatStatsConfig() {
        throw new IllegalArgumentException();
    }

    public void count(class_1309 pattedEntity) {
        ++this.totalPatsCounter.totalPats;
        class_2960 id = VersionedThings.ENTITY_TYPE.method_10221((Object)pattedEntity.method_5864());
        if (id == null) {
            return;
        }
        String entityId = id.toString();
        PatsCounter patsCounter = this.patsPerEntity.get(entityId);
        if (patsCounter == null) {
            this.patsPerEntity.put(entityId, new PatsCounter(0L));
        } else {
            ++patsCounter.totalPats;
        }
        AutoSaveManager.markToSave();
    }

    public static void registerSaveHooks() {
        AutoSaveManager.start();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> PatPatStatsConfig.getInstance().save());
    }

    public static PatPatStatsConfig getInstance() {
        return instance == null ? PatPatStatsConfig.reload() : instance;
    }

    public static PatPatStatsConfig reload() {
        instance = PatPatStatsConfig.read();
        return instance;
    }

    public static PatPatStatsConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static PatPatStatsConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    public PatsCounter getTotalPatsCounter() {
        return this.totalPatsCounter;
    }

    public HashMap<String, PatsCounter> getPatsPerEntity() {
        return this.patsPerEntity;
    }

    public void setTotalPatsCounter(PatsCounter totalPatsCounter) {
        this.totalPatsCounter = totalPatsCounter;
    }

    public void setPatsPerEntity(HashMap<String, PatsCounter> patsPerEntity) {
        this.patsPerEntity = patsPerEntity;
    }

    public PatPatStatsConfig(PatsCounter totalPatsCounter, HashMap<String, PatsCounter> patsPerEntity) {
        this.totalPatsCounter = totalPatsCounter;
        this.patsPerEntity = patsPerEntity;
    }

    private static class PatsCounter {
        public static final Codec<PatsCounter> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("pats", 0L, Codec.LONG, PatsCounter::getTotalPats)).apply((Applicative)instance, PatsCounter::new));
        public long totalPats;

        public long getTotalPats() {
            return this.totalPats;
        }

        public PatsCounter(long totalPats) {
            this.totalPats = totalPats;
        }
    }

    private static class AutoSaveManager {
        private static final ScheduledExecutorService SERVICE = Executors.newScheduledThreadPool(1);
        private static boolean shouldSave = true;

        private AutoSaveManager() {
        }

        private static void start() {
            Runnable runnable = () -> {
                if (!shouldSave || !PatPatClientConfig.getInstance().getMainConfig().isModEnabled()) {
                    return;
                }
                PatPatStatsConfig.getInstance().save();
                shouldSave = false;
            };
            SERVICE.scheduleAtFixedRate(runnable, 5L, 5L, TimeUnit.MINUTES);
        }

        private static void markToSave() {
            shouldSave = true;
        }
    }
}

