/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.common.config.PatPatConfigManager;
import net.lopymine.patpat.utils.IgnoreMobListConfigUtils;
import net.minecraft.class_1299;
import org.jetbrains.annotations.NotNull;

public class IgnoreMobListConfig {
    private static final String FILENAME = "ignore_mob_list.txt";
    private static final PatLogger LOGGER = PatPatClient.LOGGER.extend("IgnoreMobListConfig");
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("ignore_mob_list.txt").toFile();
    private static IgnoreMobListConfig instance;
    private final Set<class_1299<?>> ignoredMobs = new HashSet();

    public static IgnoreMobListConfig getInstance() {
        if (instance == null) {
            IgnoreMobListConfig.reload();
        }
        return instance;
    }

    public static void reload() {
        IgnoreMobListConfig config = new IgnoreMobListConfig();
        IgnoreMobListConfigUtils.read(CONFIG_FILE, LOGGER, config.getIgnoredMobs());
        instance = config;
    }

    public boolean addMob(@NotNull class_1299<?> type) {
        return this.ignoredMobs.add(type);
    }

    public boolean removeMob(@NotNull class_1299<?> type) {
        return this.ignoredMobs.remove(type);
    }

    public boolean isIgnored(@NotNull class_1299<?> type) {
        return this.ignoredMobs.contains(type);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        this.save(CONFIG_FILE);
    }

    public void save(File configFile) {
        IgnoreMobListConfigUtils.save(configFile, LOGGER, this.ignoredMobs);
    }

    public Set<class_1299<?>> getIgnoredMobs() {
        return this.ignoredMobs;
    }
}

