/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.hid;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HexFormat;
import java.util.List;

public record HIDIdentifier(int vendorId, int productId) {
    public static final Codec<HIDIdentifier> LIST_CODEC = Codec.list((Codec)Codec.INT).comapFlatMap(parts -> {
        if (parts.size() != 2) {
            return DataResult.error(() -> "HID identifier list must have exactly two elements, found " + parts.size());
        }
        return DataResult.success((Object)new HIDIdentifier((Integer)parts.get(0), (Integer)parts.get(1)));
    }, hid -> List.of(Integer.valueOf(hid.vendorId()), Integer.valueOf(hid.productId())));

    @Override
    public String toString() {
        HexFormat hex = HexFormat.of();
        return "HID[VID=0x" + hex.toHexDigits(this.vendorId, 4) + ", PID=0x" + hex.toHexDigits(this.productId, 4) + "]";
    }
}

