/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.arch.screen.EmoteMenu;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.inline.TmpGetters;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

public class ExportMenu
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"emotecraft.options.export");
    private static final class_2561 EXPORT_JSON = class_2561.method_43471((String)"emotecraft.exportjson");
    private static final class_2561 EXPORT_BIN = class_2561.method_43471((String)"emotecraft.exportbin");
    private final class_8132 layout = new class_8132((class_437)this);
    protected final class_437 parent;

    public ExportMenu(class_437 parent) {
        super(TITLE);
        this.parent = parent;
    }

    public void method_25426() {
        this.layout.method_57726(this.method_25440(), this.field_22793);
        class_8667 contents = (class_8667)this.layout.method_48999((class_8021)class_8667.method_52741().method_52735(8));
        contents.method_52736((class_8021)class_4185.method_46430((class_2561)EXPORT_JSON, button -> this.exportEmotesInFormat(AnimationFormat.JSON_EMOTECRAFT)).method_46432(200).method_46431());
        contents.method_52736((class_8021)class_4185.method_46430((class_2561)EXPORT_BIN, button -> this.exportEmotesInFormat(AnimationFormat.BINARY)).method_46432(200).method_46431());
        class_8667 footer = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(8));
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46431());
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)EmoteMenu.OPEN_FOLDER, button -> PlatformTools.openExternalEmotesDir()).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    private void exportEmotesInFormat(AnimationFormat format) {
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            KeyframeAnimation emote = emoteHolder.getEmote();
            if (emote.extraData.containsKey("isBuiltin") && !((ClientConfig)EmoteInstance.config).exportBuiltin.get().booleanValue()) continue;
            EmoteInstance.instance.getLogger().log(Level.FINER, "Saving " + emoteHolder.name.getString() + " into " + format.getExtension());
            try {
                Path exportDir = EmoteInstance.instance.getExternalEmoteDir().toPath().resolve(format.getExtension() + "_export");
                if (!exportDir.toFile().isDirectory()) {
                    Files.createDirectories(exportDir, new FileAttribute[0]);
                }
                Path file = ExportMenu.createFileName(emoteHolder, exportDir, format);
                OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);
                UniversalEmoteSerializer.writeKeyframeAnimation(stream, emote, format);
                stream.close();
                if (format != AnimationFormat.JSON_EMOTECRAFT || !emote.extraData.containsKey("iconData")) continue;
                Path iconPath = exportDir.resolve(file.getFileName().toString().substring(0, file.getFileName().toString().lastIndexOf(".")) + ".png");
                if (iconPath.toFile().isFile()) {
                    throw new IOException("File already exists: " + String.valueOf(iconPath));
                }
                OutputStream iconStream = Files.newOutputStream(iconPath, new OpenOption[0]);
                iconStream.write(AbstractNetworkInstance.safeGetBytesFromBuffer((ByteBuffer)emote.extraData.get("iconData")));
                iconStream.close();
            }
            catch (EmoteSerializerException | IOException | InvalidPathException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                TmpGetters.getClientMethods().toastExportMessage(2, (class_2561)class_2561.method_43471((String)("emotecraft.export.error." + format.getExtension())), emoteHolder.name.getString());
            }
        }
        TmpGetters.getClientMethods().toastExportMessage(1, (class_2561)class_2561.method_43471((String)("emotecraft.export.done." + format.getExtension())), "emotes/" + format.getExtension() + "_export/");
        EmoteInstance.instance.getLogger().log(Level.FINER, "All emotes are saved in " + format.getExtension() + " format", true);
    }

    private static Path createFileName(EmoteHolder emote, Path originPath, AnimationFormat format) {
        Object name = emote.name.getString().replaceAll("[\\\\/]", "#");
        String finalName = null;
        while (finalName == null) {
            try {
                originPath.resolve((String)name);
                finalName = name;
            }
            catch (InvalidPathException e) {
                int i = e.getIndex();
                name = ((String)name).substring(0, i) + "#" + ((String)name).substring(i + 1);
            }
        }
        int i = 2;
        Path file = originPath.resolve(finalName + "." + format.getExtension());
        if (!file.getParent().equals(originPath)) {
            finalName = Integer.toString(emote.hashCode());
            file = originPath.resolve(finalName + "." + format.getExtension());
        }
        while (file.toFile().isFile()) {
            file = originPath.resolve(finalName + "_" + i++ + "." + format.getExtension());
        }
        return file;
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }
}

