/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.utils.PlayerListConfigUtils;
import net.lopymine.patpat.utils.ResourceLocationUtils;
import net.lopymine.patpat.utils.VersionedThings;
import net.minecraft.class_1299;
import net.minecraft.class_2960;

public final class IgnoreMobListConfigUtils {
    public static void create(File config, PatLogger logger) {
        try {
            if (!config.createNewFile()) {
                logger.error("Invoked player list config creation, but config already exists!", new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("Failed to create %s config!".formatted(config.getName()), e);
        }
    }

    public static void read(File config, PatLogger logger, Set<class_1299<?>> set) {
        if (!config.exists()) {
            PlayerListConfigUtils.create(config, logger);
            return;
        }
        int lineNumber = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(config));){
            String line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                try {
                    class_1299 entityType = VersionedThings.ENTITY_TYPE.method_17966(ResourceLocationUtils.parse(line)).orElse(null);
                    if (entityType == null) {
                        logger.error("EntityType on line {} is not exist:", lineNumber, line, config.getName());
                    } else {
                        set.add(entityType);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to parse line %d while parsing IgnoreMobListConfig: %s".formatted(lineNumber, line), e);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            logger.error("Failed to reload IgnoreMobListConfig:", e);
        }
    }

    public static void save(File config, PatLogger logger, Set<class_1299<?>> set) {
        try (FileWriter writer = new FileWriter(config, StandardCharsets.UTF_8);){
            String collect = set.stream().map(entityType -> {
                class_2960 entityTypeResource = VersionedThings.ENTITY_TYPE.method_10221(entityType);
                if (entityTypeResource == null) {
                    return null;
                }
                return entityTypeResource.toString();
            }).collect(Collectors.joining("\n"));
            logger.debug("Saving list with entity types:", new Object[0]);
            logger.debug(collect, new Object[0]);
            writer.write(collect);
        }
        catch (Exception e) {
            logger.error("IgnoreMobListConfig with name " + config.getName(), e);
        }
    }

    private IgnoreMobListConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

