/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.common.config.time;

import com.mojang.serialization.Codec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lopymine.patpat.common.config.time.TimeUnit;
import net.lopymine.patpat.utils.TimeUtils;

public class Time {
    public static final Codec<Time> CODEC = Codec.STRING.xmap(Time::of, Time::toString);
    private static final String PATTERN_STRING = "(\\d+)([a-z]*)";
    private static final Pattern PATTERN = Pattern.compile("(\\d+)([a-z]*)", 2);
    private TimeUnit unit;
    private int value;

    public static Time of(String value) {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.find()) {
            Time.throwExampleException(value);
        }
        int time = Integer.parseInt(matcher.group(1));
        TimeUnit unit = TimeUtils.getUnit(matcher.group(2).toLowerCase());
        return new Time(unit, time);
    }

    public String toString() {
        return "%d%s".formatted(this.value, this.unit.getName());
    }

    private static void throwExampleException(String argument) {
        throw new IllegalArgumentException("String '%s' cannot parsed. Use a string like from the examples: 15, 30s, 20m, 1h, 2d".formatted(argument));
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public int getValue() {
        return this.value;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public Time(TimeUnit unit, int value) {
        this.unit = unit;
        this.value = value;
    }
}

