/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import me.enderkill98.proxlib.ProxPacketIdentifier;
import me.enderkill98.proxlib.client.ProxLib;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.packet.PatPatClientPacketManager;
import net.lopymine.patpat.client.packet.PatPatClientProxLibManager;
import net.lopymine.patpat.client.packet.PatPatClientProxLibPacketRateLimitManager;
import net.lopymine.patpat.compat.LoadedMods;
import net.lopymine.patpat.compat.flashback.FlashbackManager;
import net.lopymine.patpat.compat.replaymod.ReplayModManager;
import net.lopymine.patpat.packet.s2c.PatEntityS2CPacketV2;
import net.minecraft.class_310;

public class PatPatClientProxLibPacketManager {
    public static final PatLogger LOGGER = PatPatClient.LOGGER.extend("ProxLibPacketManager");
    public static final int PAT_PAT_PACKETS_ID = 2;
    public static final ProxPacketIdentifier PAT_PACKET_IDENTIFIER = ProxPacketIdentifier.of((int)2, (int)0);

    public static void register() {
        if (!LoadedMods.PROX_LIB_MOD_LOADED) {
            return;
        }
        ProxLib.addHandlerFor((ProxPacketIdentifier)PAT_PACKET_IDENTIFIER, (entity, id, data) -> {
            LOGGER.debug("Received proximity packet, ProxLib enabled: {}", PatPatClientProxLibManager.isEnabled());
            if (!PatPatClientProxLibManager.isEnabled()) {
                return;
            }
            try {
                int pattedEntityId = PatPatClientProxLibPacketManager.decodeProxyPatPacket(data);
                int whoPattedId = entity.method_5628();
                PatPatClientPacketManager.handlePatting(new PatEntityS2CPacketV2(pattedEntityId, whoPattedId), FlashbackManager.isInReplay() || ReplayModManager.isInReplay());
            }
            catch (Exception e) {
                LOGGER.debug("Failed to handle proximity packet from player: {}, packet id: {}, data: {}", entity.method_5477().getString(), id, data, e);
            }
        });
    }

    public static void onPat(int pattedEntityId) {
        if (!LoadedMods.PROX_LIB_MOD_LOADED) {
            return;
        }
        if (!PatPatClientProxLibManager.isEnabled()) {
            return;
        }
        if (PatPatClientProxLibPacketRateLimitManager.isLimitExceeded()) {
            LOGGER.debug("Trying to make proximity pat, but max packets limit is exceeded!", new Object[0]);
            return;
        }
        try {
            int packetsCount = ProxLib.sendPacket((class_310)class_310.method_1551(), (ProxPacketIdentifier)PAT_PACKET_IDENTIFIER, (byte[])PatPatClientProxLibPacketManager.encodeProxyPatPacket(pattedEntityId));
            LOGGER.debug("Sent proximity packets ({}) to pat entity with id {}", packetsCount, pattedEntityId);
            PatPatClientProxLibPacketRateLimitManager.countPacket();
        }
        catch (Exception e) {
            LOGGER.debug("Failed to send proximity packet, patted entity: {}, packet id: {}, data: {}", pattedEntityId, 2, e);
        }
    }

    private static int decodeProxyPatPacket(byte[] data) throws IOException {
        ByteArrayInputStream array = new ByteArrayInputStream(data);
        DataInputStream input = new DataInputStream(array);
        int pattedEntityId = PatPatClientProxLibPacketManager.readVarInt(input);
        array.close();
        return pattedEntityId;
    }

    private static byte[] encodeProxyPatPacket(int pattedEntityId) throws IOException {
        ByteArrayOutputStream array = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(array);
        PatPatClientProxLibPacketManager.writeVarInt(data, pattedEntityId);
        data.close();
        return array.toByteArray();
    }

    private static int readVarInt(DataInput input) throws IOException {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = input.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    private static void writeVarInt(DataOutputStream data, int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            data.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        data.writeByte(value);
    }
}

