/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config.sub;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.lopymine.patpat.client.packet.PatPatClientProxLibManager;
import net.lopymine.patpat.utils.CodecUtils;

public class PatPatClientProximityPacketsConfig {
    public static final PatPatClientProximityPacketsConfig DEFAULT = new PatPatClientProximityPacketsConfig(true, 10);
    public static final Codec<PatPatClientProximityPacketsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("proximityPacketsEnabled", PatPatClientProximityPacketsConfig.DEFAULT.proximityPacketsEnabled, Codec.BOOL, PatPatClientProximityPacketsConfig::isProximityPacketsEnabled), CodecUtils.option("maxPacketsPerSecond", PatPatClientProximityPacketsConfig.DEFAULT.maxPacketsPerSecond, Codec.INT, PatPatClientProximityPacketsConfig::getMaxPacketsPerSecond)).apply((Applicative)instance, PatPatClientProximityPacketsConfig::new));
    private boolean proximityPacketsEnabled;
    private int maxPacketsPerSecond;

    public static PatPatClientProximityPacketsConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    public void setProximityPacketsEnabled(boolean value) {
        this.proximityPacketsEnabled = value;
        PatPatClientProxLibManager.setEnabled(value);
    }

    public PatPatClientProximityPacketsConfig copy() {
        return new PatPatClientProximityPacketsConfig(this.proximityPacketsEnabled, this.maxPacketsPerSecond);
    }

    public boolean isProximityPacketsEnabled() {
        return this.proximityPacketsEnabled;
    }

    public int getMaxPacketsPerSecond() {
        return this.maxPacketsPerSecond;
    }

    public void setMaxPacketsPerSecond(int maxPacketsPerSecond) {
        this.maxPacketsPerSecond = maxPacketsPerSecond;
    }

    public PatPatClientProximityPacketsConfig(boolean proximityPacketsEnabled, int maxPacketsPerSecond) {
        this.proximityPacketsEnabled = proximityPacketsEnabled;
        this.maxPacketsPerSecond = maxPacketsPerSecond;
    }
}

