/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.resourcepack.CustomAnimationSettingsConfig;
import net.lopymine.patpat.client.config.resourcepack.EntityConfig;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.common.Version;
import net.lopymine.patpat.extension.EntityExtension;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomAnimationConfig
implements Comparable<CustomAnimationConfig> {
    public static final Codec<CustomAnimationConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Version.CODEC.fieldOf("version").forGetter(CustomAnimationConfig::getVersion), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(CustomAnimationConfig::getPriority), (App)CustomAnimationSettingsConfig.CODEC.fieldOf("animation").forGetter(CustomAnimationConfig::getAnimation), (App)Codec.BOOL.optionalFieldOf("blacklist", (Object)false).forGetter(CustomAnimationConfig::isBlacklist), (App)EntityConfig.LISTED_CODEC.fieldOf("entities").forGetter(CustomAnimationConfig::getEntities)).apply((Applicative)instance, CustomAnimationConfig::new));
    private final Version version;
    private final int priority;
    private final CustomAnimationSettingsConfig animation;
    private final boolean blacklist;
    private final boolean useForAll;
    private List<EntityConfig> entities;
    private String configPath;

    public CustomAnimationConfig(Version version, int priority, CustomAnimationSettingsConfig animation, boolean blacklist, List<EntityConfig> entities) {
        this.version = version;
        this.priority = priority;
        this.animation = animation;
        this.blacklist = blacklist;
        this.entities = entities;
        this.useForAll = entities.stream().anyMatch(config -> config.getEntityId().equals("all"));
    }

    public boolean canUseFor(@NotNull class_1297 entity, @NotNull PlayerConfig whoPatted) {
        return this.canUseFor(EntityExtension.getTypeId(entity), entity.method_5477().getString(), entity.method_5667(), whoPatted);
    }

    public boolean canUseFor(@NotNull String entityTypeId, @Nullable String entityName, @Nullable UUID entityUuid, @NotNull PlayerConfig whoPatted) {
        if (this.useForAll) {
            return !this.blacklist;
        }
        for (EntityConfig entityConfig : this.entities) {
            PatPatClient.LOGGER.debug("Comparing Entity Config: " + entityConfig.toString(), new Object[0]);
            PatPatClient.LOGGER.debug("with {}, {}, {}, {}", entityTypeId, entityName, entityUuid, whoPatted.toString());
            if (!entityConfig.is(entityTypeId, entityName, entityUuid) || entityConfig.getEntitiesFrom() != null && !entityConfig.getEntitiesFrom().contains(whoPatted)) continue;
            return !this.blacklist;
        }
        return this.blacklist;
    }

    @Override
    public int compareTo(@NotNull CustomAnimationConfig o) {
        int compare = Integer.compare(this.priority, o.getPriority());
        if (compare == 0) {
            compare = this.configPath.compareTo(o.getConfigPath());
        }
        return compare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomAnimationConfig that = (CustomAnimationConfig)o;
        return this.priority == that.priority && this.blacklist == that.blacklist && this.useForAll == that.useForAll && Objects.equals(this.version, that.version) && Objects.equals(this.animation, that.animation) && Objects.equals(this.entities, that.entities);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.priority, this.animation, this.blacklist, this.useForAll, this.entities);
    }

    public String toString() {
        return "CustomAnimationConfig{version='%s',priority='%s', animation='%s', blacklist='%s', useForAll='%s', entities=%s}".formatted(this.version, this.priority, this.animation, this.blacklist, this.useForAll, this.entities);
    }

    public Version getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    public CustomAnimationSettingsConfig getAnimation() {
        return this.animation;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public boolean isUseForAll() {
        return this.useForAll;
    }

    public List<EntityConfig> getEntities() {
        return this.entities;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setEntities(List<EntityConfig> entities) {
        this.entities = entities;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }
}

