/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.common.config.PatPatConfigManager;
import net.lopymine.patpat.utils.PlayerListConfigUtils;

public class PatPatClientPlayerListConfig {
    private static final String FILENAME = "player-list-client.txt";
    private static final PatLogger LOGGER = PatPatClient.LOGGER.extend("PlayerListConfig");
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("player-list-client.txt").toFile();
    private static PatPatClientPlayerListConfig INSTANCE;
    private final Map<UUID, String> map = new HashMap<UUID, String>();

    public static PatPatClientPlayerListConfig getInstance() {
        if (INSTANCE == null) {
            return PatPatClientPlayerListConfig.reload();
        }
        return INSTANCE;
    }

    public static PatPatClientPlayerListConfig reload() {
        PatPatClientPlayerListConfig config = new PatPatClientPlayerListConfig();
        PlayerListConfigUtils.read(CONFIG_FILE, LOGGER, config.getMap());
        INSTANCE = config;
        return INSTANCE;
    }

    public boolean contains(UUID uuid) {
        return this.map.containsKey(uuid);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        this.save(CONFIG_FILE);
    }

    public void save(File configFile) {
        PlayerListConfigUtils.save(configFile, LOGGER, this.map);
    }

    public Map<UUID, String> getMap() {
        return this.map;
    }
}

