/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.sub.PatPatClientMainConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientMultiplayerConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientProximityPacketsConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientResourcePacksConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientSoundsConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientVisualConfig;
import net.lopymine.patpat.common.Version;
import net.lopymine.patpat.common.config.PatPatConfigManager;
import net.lopymine.patpat.utils.CodecUtils;
import net.lopymine.patpat.utils.ConfigUtils;

public class PatPatClientConfig {
    public static final PatPatClientConfig DEFAULT = new PatPatClientConfig(Version.CLIENT_CONFIG_VERSION, PatPatClientMainConfig.DEFAULT, PatPatClientResourcePacksConfig.DEFAULT, PatPatClientSoundsConfig.DEFAULT, PatPatClientVisualConfig.DEFAULT, PatPatClientMultiplayerConfig.DEFAULT, PatPatClientProximityPacketsConfig.DEFAULT);
    public static final Codec<PatPatClientConfig> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("version", PatPatClientConfig.DEFAULT.version, Version.CODEC, PatPatClientConfig::getVersion), CodecUtils.option("main", () -> PatPatClientConfig.DEFAULT.mainConfig.copy(), PatPatClientMainConfig.CODEC, PatPatClientConfig::getMainConfig), CodecUtils.option("resourcePacks", () -> PatPatClientConfig.DEFAULT.resourcePacksConfig.copy(), PatPatClientResourcePacksConfig.CODEC, PatPatClientConfig::getResourcePacksConfig), CodecUtils.option("sounds", () -> PatPatClientConfig.DEFAULT.soundsConfig.copy(), PatPatClientSoundsConfig.CODEC, PatPatClientConfig::getSoundsConfig), CodecUtils.option("visual", () -> PatPatClientConfig.DEFAULT.visualConfig.copy(), PatPatClientVisualConfig.CODEC, PatPatClientConfig::getVisualConfig), CodecUtils.option("multiplayer", () -> PatPatClientConfig.DEFAULT.multiPlayerConfig.copy(), PatPatClientMultiplayerConfig.CODEC, PatPatClientConfig::getMultiPlayerConfig), CodecUtils.option("proximityPackets", () -> PatPatClientConfig.DEFAULT.proximityPacketsConfig.copy(), PatPatClientProximityPacketsConfig.CODEC, PatPatClientConfig::getProximityPacketsConfig)).apply((Applicative)inst, PatPatClientConfig::new));
    private static final PatLogger LOGGER = PatPatClient.LOGGER.extend("Config");
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("patpat-client.json5").toFile();
    private static PatPatClientConfig instance;
    private Version version;
    private PatPatClientMainConfig mainConfig;
    private PatPatClientResourcePacksConfig resourcePacksConfig;
    private PatPatClientSoundsConfig soundsConfig;
    private PatPatClientVisualConfig visualConfig;
    private PatPatClientMultiplayerConfig multiPlayerConfig;
    private PatPatClientProximityPacketsConfig proximityPacketsConfig;

    public static PatPatClientConfig getInstance() {
        return instance == null ? PatPatClientConfig.reload() : instance;
    }

    public static PatPatClientConfig reload() {
        instance = PatPatClientConfig.read();
        return instance;
    }

    public static PatPatClientConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static PatPatClientConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    public Version getVersion() {
        return this.version;
    }

    public PatPatClientMainConfig getMainConfig() {
        return this.mainConfig;
    }

    public PatPatClientResourcePacksConfig getResourcePacksConfig() {
        return this.resourcePacksConfig;
    }

    public PatPatClientSoundsConfig getSoundsConfig() {
        return this.soundsConfig;
    }

    public PatPatClientVisualConfig getVisualConfig() {
        return this.visualConfig;
    }

    public PatPatClientMultiplayerConfig getMultiPlayerConfig() {
        return this.multiPlayerConfig;
    }

    public PatPatClientProximityPacketsConfig getProximityPacketsConfig() {
        return this.proximityPacketsConfig;
    }

    public PatPatClientConfig(Version version, PatPatClientMainConfig mainConfig, PatPatClientResourcePacksConfig resourcePacksConfig, PatPatClientSoundsConfig soundsConfig, PatPatClientVisualConfig visualConfig, PatPatClientMultiplayerConfig multiPlayerConfig, PatPatClientProximityPacketsConfig proximityPacketsConfig) {
        this.version = version;
        this.mainConfig = mainConfig;
        this.resourcePacksConfig = resourcePacksConfig;
        this.soundsConfig = soundsConfig;
        this.visualConfig = visualConfig;
        this.multiPlayerConfig = multiPlayerConfig;
        this.proximityPacketsConfig = proximityPacketsConfig;
    }
}

