/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatLogger {
    private final Logger logger;
    private final String name;
    @Nullable
    private final PatLogger parent;
    private boolean debugMode = false;

    public PatLogger(String name) {
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)this.name);
        this.parent = null;
    }

    public PatLogger(String name, @Nullable PatLogger parent) {
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)this.name);
        this.parent = parent;
    }

    public void debug(String text, Object ... args) {
        if (this.isDebugModeEnabled()) {
            text = "[%s/DEBUG]: %s".formatted(this.name, text);
            this.logger.info(text, args);
        }
    }

    private boolean isDebugModeEnabled() {
        return this.debugMode || this.parent != null && this.parent.isDebugModeEnabled();
    }

    public void info(String text, Object ... args) {
        text = this.prepare(text);
        this.logger.info(text, args);
    }

    public void warn(String text, Object ... args) {
        text = this.prepare(text);
        this.logger.warn(text, args);
    }

    public void error(String text, Throwable error) {
        text = this.prepare(text);
        this.logger.error(text, error);
    }

    public void error(String text, Object ... args) {
        text = this.prepare(text);
        this.logger.error(text, args);
    }

    public PatLogger extend(String name) {
        return new PatLogger("%s/%s".formatted(this.name, name), this);
    }

    private String prepare(String text) {
        return "[%s]: %s".formatted(this.name, text);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

