/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicMap<K, V>
implements Map<K, V> {
    protected final Function<K, V> function;
    private final Class<K> keyClass;

    public DynamicMap(Class<K> keyClass, Function<K, V> function) {
        this.keyClass = keyClass;
        this.function = function;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object o) {
        return true;
    }

    @Override
    public boolean containsValue(Object o) {
        return true;
    }

    @Override
    public V get(Object o) {
        if (!this.keyClass.isInstance(o)) {
            return null;
        }
        return this.function.apply(o);
    }

    @Override
    @Nullable
    public V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.emptySet();
    }
}

