/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FrequencyOrderedCollection<T>
implements Collection<T> {
    private final Map<T, Integer> frequencies = new HashMap<T, Integer>();
    private List<Map.Entry<T, Integer>> sortedEntries = new ArrayList<Map.Entry<T, Integer>>();

    @Override
    public boolean add(T obj) {
        return this.add(obj, 1);
    }

    public boolean add(T obj, int count) {
        if (count <= 0) {
            return false;
        }
        boolean wasAdded = this.frequencies.containsKey(obj);
        this.frequencies.merge(obj, count, Integer::sum);
        if (wasAdded) {
            this.updateSortedEntries();
        } else {
            this.sortedEntries = new ArrayList<Map.Entry<T, Integer>>(this.frequencies.entrySet());
            this.sortedEntries.sort((entry1, entry2) -> ((Integer)entry2.getValue()).compareTo((Integer)entry1.getValue()));
        }
        return true;
    }

    public boolean remove(T obj, int count) {
        if (count <= 0 || !this.frequencies.containsKey(obj)) {
            return false;
        }
        this.frequencies.merge(obj, -count, (oldCount, delta) -> {
            int newCount = oldCount + delta;
            return newCount > 0 ? Integer.valueOf(newCount) : null;
        });
        this.updateSortedEntries();
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (this.frequencies.remove(obj) != null) {
            this.updateSortedEntries();
            return true;
        }
        return false;
    }

    public boolean removeAllOccurrences(T obj) {
        return this.remove(obj);
    }

    private void updateSortedEntries() {
        this.sortedEntries = new ArrayList<Map.Entry<T, Integer>>(this.frequencies.entrySet());
        this.sortedEntries.sort((entry1, entry2) -> ((Integer)entry2.getValue()).compareTo((Integer)entry1.getValue()));
    }

    public T getFirst() {
        if (!this.sortedEntries.isEmpty()) {
            return this.sortedEntries.get(0).getKey();
        }
        return null;
    }

    public T getLast() {
        if (!this.sortedEntries.isEmpty()) {
            return this.sortedEntries.get(this.sortedEntries.size() - 1).getKey();
        }
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.sortedEntries.stream().map(Map.Entry::getKey).iterator();
    }

    @Override
    public int size() {
        return this.frequencies.size();
    }

    @Override
    public boolean isEmpty() {
        return this.frequencies.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.frequencies.containsKey(obj);
    }

    @Override
    public Object[] toArray() {
        return this.sortedEntries.stream().map(Map.Entry::getKey).toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.sortedEntries.stream().map(Map.Entry::getKey).toArray((int size) -> a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.frequencies.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T item : c) {
            changed |= this.add(item);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object item : c) {
            changed |= this.remove(item);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<T> iterator = this.iterator();
        HashSet<T> toRemove = new HashSet<T>();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (c.contains(item)) continue;
            toRemove.add(item);
        }
        for (Object item : toRemove) {
            this.frequencies.remove(item);
            changed = true;
        }
        if (changed) {
            this.updateSortedEntries();
        }
        return changed;
    }

    @Override
    public void clear() {
        this.frequencies.clear();
        this.sortedEntries.clear();
    }
}

