/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes.textured;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.Skybox;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.SkyboxType;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.TexturedSkybox;
import io.github.amerebagatelle.fabricskyboxes.util.Utils;
import io.github.amerebagatelle.fabricskyboxes.util.object.Animation;
import io.github.amerebagatelle.fabricskyboxes.util.object.Blend;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.UVRange;
import io.github.amerebagatelle.fabricskyboxes.util.object.UVRanges;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class MultiTextureSkybox
extends TexturedSkybox {
    public static Codec<MultiTextureSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.fieldOf("properties").forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.DEFAULT).forGetter(AbstractSkybox::getConditions), (App)Decorations.CODEC.optionalFieldOf("decorations", (Object)Decorations.DEFAULT).forGetter(AbstractSkybox::getDecorations), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.DEFAULT).forGetter(TexturedSkybox::getBlend), (App)Animation.CODEC.listOf().optionalFieldOf("animations", new ArrayList()).forGetter(MultiTextureSkybox::getAnimations)).apply((Applicative)instance, MultiTextureSkybox::new));
    protected final List<Animation> animations;
    private final UVRanges uvRanges;
    private final float quadSize = 100.0f;
    private final UVRange quad = new UVRange(-this.quadSize, -this.quadSize, this.quadSize, this.quadSize);

    public MultiTextureSkybox(Properties properties, Conditions conditions, Decorations decorations, Blend blend, List<Animation> animations) {
        super(properties, conditions, decorations, blend);
        this.animations = animations;
        this.uvRanges = (UVRanges)class_156.method_656(() -> new UVRanges(new UVRange(0.33333334f, 0.5f, 0.6666667f, 1.0f), new UVRange(0.6666667f, 0.0f, 1.0f, 0.5f), new UVRange(0.6666667f, 0.5f, 1.0f, 1.0f), new UVRange(0.0f, 0.5f, 0.33333334f, 1.0f), new UVRange(0.33333334f, 0.0f, 0.6666667f, 0.5f), new UVRange(0.0f, 0.0f, 0.33333334f, 0.5f)));
    }

    @Override
    public SkyboxType<? extends Skybox> getType() {
        return SkyboxType.MULTI_TEXTURE_SKYBOX;
    }

    @Override
    public void renderSkybox(WorldRendererAccess worldRendererAccess, class_4587 matrices, float tickDelta, class_4184 camera, boolean thickFog, Runnable runnable) {
        for (int i = 0; i < 6; ++i) {
            UVRange faceUVRange = this.uvRanges.byId(i);
            matrices.method_22903();
            if (i == 1) {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            } else if (i == 2) {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            } else if (i == 3) {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            } else if (i == 4) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            } else if (i == 5) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            }
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            for (Animation animation : this.animations) {
                animation.tick();
                UVRange intersect = Utils.findUVIntersection(faceUVRange, animation.getUvRanges());
                if (intersect == null || animation.getCurrentFrame() == null) continue;
                class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                UVRange intersectionOnCurrentTexture = Utils.mapUVRanges(faceUVRange, this.quad, intersect);
                UVRange intersectionOnCurrentFrame = Utils.mapUVRanges(animation.getUvRanges(), animation.getCurrentFrame(), intersect);
                RenderSystem.setShaderTexture((int)0, (class_2960)animation.getTexture().getTextureId());
                bufferBuilder.method_22918(matrix4f, intersectionOnCurrentTexture.getMinU(), -this.quadSize, intersectionOnCurrentTexture.getMinV()).method_22913(intersectionOnCurrentFrame.getMinU(), intersectionOnCurrentFrame.getMinV());
                bufferBuilder.method_22918(matrix4f, intersectionOnCurrentTexture.getMinU(), -this.quadSize, intersectionOnCurrentTexture.getMaxV()).method_22913(intersectionOnCurrentFrame.getMinU(), intersectionOnCurrentFrame.getMaxV());
                bufferBuilder.method_22918(matrix4f, intersectionOnCurrentTexture.getMaxU(), -this.quadSize, intersectionOnCurrentTexture.getMaxV()).method_22913(intersectionOnCurrentFrame.getMaxU(), intersectionOnCurrentFrame.getMaxV());
                bufferBuilder.method_22918(matrix4f, intersectionOnCurrentTexture.getMaxU(), -this.quadSize, intersectionOnCurrentTexture.getMinV()).method_22913(intersectionOnCurrentFrame.getMaxU(), intersectionOnCurrentFrame.getMinV());
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
            }
            matrices.method_22909();
        }
    }

    public List<Animation> getAnimations() {
        return this.animations;
    }
}

