/*
 * Decompiled with CFR 0.152.
 */
package borknbeans.lightweightinventorysorting.sorting;

import borknbeans.lightweightinventorysorting.LightweightInventorySorting;
import borknbeans.lightweightinventorysorting.config.LightweightInventorySortingConfig;
import borknbeans.lightweightinventorysorting.sorting.HandHelper;
import borknbeans.lightweightinventorysorting.sorting.SortableSlot;
import borknbeans.lightweightinventorysorting.sorting.SortableSlotComparator;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SortingHelper {
    public static void sortInventory(class_310 client, int startIndex, int endIndex) {
        if (client.field_1724 == null) {
            return;
        }
        int syncId = client.field_1724.field_7512.field_7763;
        class_2371 slots = client.field_1724.field_7512.field_7761;
        ArrayList<SortableSlot> sortableSlots = new ArrayList<SortableSlot>();
        LightweightInventorySorting.LOGGER.info("Collecting sort details...");
        for (int i = startIndex; i <= endIndex; ++i) {
            class_1799 stack = ((class_1735)slots.get(i)).method_7677();
            if (stack.method_7960()) continue;
            LightweightInventorySorting.LOGGER.info(i + ": " + stack.method_7964().getString() + ", " + stack.method_7947() + "/" + stack.method_7914() + ", " + stack.method_7909().method_7848().getString());
            sortableSlots.add(new SortableSlot(i, stack));
        }
        class_1799 mouseStack = SortingHelper.stackAttachedToMouse(client);
        if (mouseStack != null) {
            LightweightInventorySorting.LOGGER.info("MOUSE: " + mouseStack.method_7964().getString() + ", " + mouseStack.method_7947() + "/" + mouseStack.method_7914() + ", " + mouseStack.method_7909().method_7848().getString());
            int index = SortingHelper.findEmptySlotIndex((class_2371<class_1735>)slots, startIndex, endIndex);
            if (index == -1) {
                LightweightInventorySorting.LOGGER.info("An error occurred while attempting to sort items in slots with an item already selected!");
                return;
            }
            SortingHelper.move(client, syncId, -1, index, new HandHelper());
            sortableSlots.add(new SortableSlot(index, mouseStack));
        }
        LightweightInventorySorting.LOGGER.info("Sorting starting now...");
        sortableSlots.sort(new SortableSlotComparator());
        new Thread(() -> {
            SortingHelper.combineLikeItems(client, syncId, (class_2371<class_1735>)slots, sortableSlots, startIndex, endIndex);
            sortableSlots.sort(new SortableSlotComparator());
            SortingHelper.sortItems(client, syncId, (class_2371<class_1735>)slots, sortableSlots, startIndex);
        }).start();
    }

    private static void combineLikeItems(class_310 client, int syncId, class_2371<class_1735> slots, List<SortableSlot> sortedSlots, int startIndex, int endIndex) {
        for (int i = sortedSlots.size() - 1; i >= 1; --i) {
            class_1799 stack = sortedSlots.get(i).getStack();
            if (stack.method_7947() == stack.method_7914()) continue;
            int index = i - 1;
            HandHelper hand = new HandHelper();
            for (int j = index; j >= 0; --j) {
                int combinedCount;
                class_1799 stackPrev = sortedSlots.get(j).getStack();
                if (hand.stack != null && !class_1799.method_31577((class_1799)stackPrev, (class_1799)hand.stack) || !class_1799.method_31577((class_1799)stack, (class_1799)stackPrev) && !hand.exists) {
                    if (!hand.exists) break;
                    SortingHelper.move(client, syncId, 0, sortedSlots.get(i).getIndex(), hand);
                    sortedSlots.get(i).setStack(hand.stack.method_7972());
                    hand.Reset();
                    break;
                }
                if (stackPrev.method_7947() == stackPrev.method_7914()) continue;
                int n = combinedCount = hand.exists ? hand.count + stackPrev.method_7947() : stack.method_7947() + stackPrev.method_7947();
                if (combinedCount <= stackPrev.method_7914()) {
                    SortingHelper.move(client, syncId, sortedSlots.get(i).getIndex(), sortedSlots.get(j).getIndex(), hand);
                    sortedSlots.remove(i);
                    if (!hand.exists) break;
                    hand.Reset();
                    break;
                }
                SortingHelper.move(client, syncId, sortedSlots.get(i).getIndex(), sortedSlots.get(j).getIndex(), hand);
                hand.exists = true;
                class_1799 stackCopy = stackPrev.method_7972();
                stackCopy.method_7939(combinedCount - stackPrev.method_7914());
                hand.stack = stackCopy;
                hand.count = stackCopy.method_7947();
            }
            if (hand.exists) {
                int emptySlot = -1;
                for (int j = startIndex; j < endIndex; ++j) {
                    if (!((class_1735)slots.get(j)).method_7677().method_7960()) continue;
                    emptySlot = j;
                    break;
                }
                if (emptySlot != -1) {
                    SortingHelper.move(client, syncId, 0, emptySlot, hand);
                    if (sortedSlots.get(i).getIndex() != emptySlot) {
                        sortedSlots.get(i).setIndex(emptySlot);
                        hand.stack.method_7939(hand.count);
                        sortedSlots.get(i).setStack(hand.stack.method_7972());
                    }
                    hand.Reset();
                } else {
                    System.out.println("Something went wrong combining items");
                }
            }
            try {
                Thread.sleep(LightweightInventorySortingConfig.sortDelay);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void move(class_310 client, int syncId, int source, int dest, HandHelper hand) {
        if (!hand.exists) {
            client.field_1761.method_2906(syncId, source, 0, class_1713.field_7790, (class_1657)client.field_1724);
        }
        client.field_1761.method_2906(syncId, dest, 0, class_1713.field_7790, (class_1657)client.field_1724);
    }

    private static void sortItems(class_310 client, int syncId, class_2371<class_1735> slots, List<SortableSlot> sortedSlots, int startIndex) {
        HandHelper hand = new HandHelper();
        for (int i = 0; i < sortedSlots.size(); ++i) {
            if (sortedSlots.get((int)i).sorted) continue;
            SortingHelper.sortItem(client, syncId, slots, sortedSlots, i, startIndex, hand);
        }
    }

    private static void sortItem(class_310 client, int syncId, class_2371<class_1735> slots, List<SortableSlot> sortedSlots, int index, int startIndex, HandHelper hand) {
        try {
            Thread.sleep(LightweightInventorySortingConfig.sortDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int dest = startIndex + index;
        if (dest == sortedSlots.get(index).getIndex()) {
            sortedSlots.get((int)index).sorted = true;
            return;
        }
        class_1799 destStack = ((class_1735)slots.get(dest)).method_7677();
        SortingHelper.move(client, syncId, sortedSlots.get(index).getIndex(), dest, hand);
        sortedSlots.get((int)index).sorted = true;
        if (!destStack.method_7960()) {
            hand.exists = true;
            hand.stack = destStack;
            hand.count = destStack.method_7947();
            int sortedSlotListIndex = -1;
            for (int i = 0; i < sortedSlots.size(); ++i) {
                if (sortedSlots.get(i).getIndex() != dest) continue;
                sortedSlotListIndex = i;
                break;
            }
            if (sortedSlotListIndex == -1) {
                System.out.println("Something went wrong with sorting the items.");
                return;
            }
            SortingHelper.sortItem(client, syncId, slots, sortedSlots, sortedSlotListIndex, startIndex, hand);
        } else {
            hand.Reset();
        }
    }

    private static class_1799 stackAttachedToMouse(class_310 client) {
        if (client.field_1724 == null) {
            return null;
        }
        class_1799 cursorStack = client.field_1724.field_7512.method_34255();
        return cursorStack.method_7960() ? null : cursorStack;
    }

    private static int findEmptySlotIndex(class_2371<class_1735> slots, int startIndex, int endIndex) {
        for (int i = startIndex; i <= endIndex; ++i) {
            class_1799 stack = ((class_1735)slots.get(i)).method_7677();
            if (!stack.method_7960()) continue;
            return i;
        }
        return -1;
    }
}

