/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.pack;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7367;
import shcm.shsupercm.fabric.citresewn.CITResewn;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.cit.CITRegistry;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.core.FallbackCondition;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.core.WeightCondition;
import shcm.shsupercm.fabric.citresewn.pack.GlobalProperties;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public final class PackParser {
    public static final List<String> ROOTS = List.of("mcpatcher", "optifine", "citresewn");

    private PackParser() {
    }

    public static GlobalProperties loadGlobalProperties(class_3300 resourceManager, GlobalProperties globalProperties) {
        for (class_3262 pack : resourceManager.method_29213().collect(Collectors.toList())) {
            for (String namespace : pack.method_14406(class_3264.field_14188)) {
                for (String root : ROOTS) {
                    class_2960 identifier = class_2960.method_60655((String)namespace, (String)(root + "/cit.properties"));
                    try {
                        class_7367 citPropertiesSupplier = pack.method_14405(class_3264.field_14188, identifier);
                        if (citPropertiesSupplier == null) continue;
                        globalProperties.load(pack.method_14409(), identifier, (InputStream)citPropertiesSupplier.get());
                    }
                    catch (FileNotFoundException citPropertiesSupplier) {
                    }
                    catch (Exception e) {
                        CITResewn.logErrorLoading("Errored while loading global properties: " + String.valueOf(identifier) + " from " + pack.method_14409());
                        e.printStackTrace();
                    }
                }
            }
        }
        return globalProperties;
    }

    public static List<CIT<?>> parseCITs(class_3300 resourceManager) {
        ArrayList cits = new ArrayList();
        for (String root : ROOTS) {
            for (Map.Entry entry : resourceManager.method_14488(root + "/cit", s -> s.method_12832().endsWith(".properties")).entrySet()) {
                String packName = null;
                try {
                    packName = ((class_3298)entry.getValue()).method_45304().method_14409();
                    cits.add(PackParser.parseCIT(PropertyGroup.tryParseGroup(packName, (class_2960)entry.getKey(), ((class_3298)entry.getValue()).method_14482()), resourceManager));
                }
                catch (CITParsingException e) {
                    CITResewn.logErrorLoading(e.getMessage());
                }
                catch (Exception e) {
                    CITResewn.logErrorLoading("Errored while loading cit: " + String.valueOf(entry.getKey()) + (String)(packName == null ? "" : " from " + packName));
                    e.printStackTrace();
                }
            }
        }
        return cits;
    }

    public static CIT<?> parseCIT(PropertyGroup properties, class_3300 resourceManager) throws CITParsingException {
        CITType citType = CITRegistry.parseType(properties);
        ArrayList<CITCondition> conditions = new ArrayList<CITCondition>();
        Set<PropertyKey> ignoredProperties = citType.typeProperties();
        for (Map.Entry<PropertyKey, Set<PropertyValue>> entry : properties.properties.entrySet()) {
            if (entry.getKey().path().equals("type") && entry.getKey().namespace().equals("citresewn") || ignoredProperties.contains(entry.getKey())) continue;
            for (PropertyValue propertyValue : entry.getValue()) {
                conditions.add(CITRegistry.parseCondition(entry.getKey(), propertyValue, properties));
            }
        }
        for (CITCondition condition2 : new ArrayList(conditions)) {
            if (condition2 == null) continue;
            for (Class clazz : condition2.siblingConditions()) {
                conditions.replaceAll(siblingCondition -> siblingCondition != null && siblingConditionType == siblingCondition.getClass() ? condition2.modifySibling(siblingCondition) : siblingCondition);
            }
        }
        WeightCondition weight = new WeightCondition();
        FallbackCondition fallback = new FallbackCondition();
        conditions.removeIf(condition -> {
            if (condition instanceof WeightCondition) {
                WeightCondition weightCondition = (WeightCondition)condition;
                weight.setWeight(weightCondition.getWeight());
                return true;
            }
            if (condition instanceof FallbackCondition) {
                FallbackCondition fallbackCondition = (FallbackCondition)condition;
                fallback.setFallback(fallbackCondition.getFallback());
                return true;
            }
            return condition == null;
        });
        citType.load(conditions, properties, resourceManager);
        return new CIT<CITType>(properties.identifier, properties.packName, citType, conditions.toArray(new CITCondition[0]), weight.getWeight(), fallback.getFallback());
    }
}

