/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin;

import com.github.exopandora.shouldersurfing.ShoulderSurfingCommon;
import com.github.exopandora.shouldersurfing.api.callback.ICameraEntityTransparencyCallback;
import com.github.exopandora.shouldersurfing.api.callback.ITickableCallback;
import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingPlugin;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingRegistrar;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.plugin.CreateModTargetCameraOffsetCallback;
import com.github.exopandora.shouldersurfing.config.Config;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5272;
import net.minecraft.class_7923;

public class ShoulderSurfingPlugin
implements IShoulderSurfingPlugin {
    private static final float MIN_CAMERA_ENTITY_ALPHA = 0.15f;

    @Override
    public void register(IShoulderSurfingRegistrar registrar) {
        registrar.registerAdaptiveItemCallback(ShoulderSurfingPlugin::isHoldingAdaptiveItem);
        registrar.registerCameraEntityTransparencyCallback(ShoulderSurfingPlugin::getCameraEntityAlpha);
        registrar.registerCameraEntityTransparencyCallback(new CameraEntityTransparencyCallbackWhenAiming());
        if (Mods.CREATE.isLoaded()) {
            try {
                ShoulderSurfingCommon.LOGGER.info("Registering compatibility callback for create mod");
                registrar.registerTargetCameraOffsetCallback(new CreateModTargetCameraOffsetCallback());
            }
            catch (Throwable t) {
                ShoulderSurfingCommon.LOGGER.error("Failed to load compatibility callback for create mod", t);
            }
        }
    }

    private static boolean isHoldingAdaptiveItem(class_310 minecraft, class_1309 entity) {
        class_1799 useStack = entity.method_6030();
        List<? extends String> useItems = Config.CLIENT.getAdaptiveCrosshairUseItems();
        List<? extends String> useItemProperties = Config.CLIENT.getAdaptiveCrosshairUseItemProperties();
        String useItemId = class_7923.field_41178.method_10221((Object)useStack.method_7909()).toString();
        if (useItems.stream().map(ShoulderSurfingPlugin::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(useItemId))) {
            return true;
        }
        for (String string : useItemProperties) {
            if (class_5272.method_27878((class_1799)useStack, (class_2960)class_2960.method_60654((String)string)) == null) continue;
            return true;
        }
        List<? extends String> holdItems = Config.CLIENT.getAdaptiveCrosshairHoldItems();
        List<? extends String> list = Config.CLIENT.getAdaptiveCrosshairHoldItemProperties();
        for (class_1799 handStack : entity.method_5877()) {
            String handItemId = class_7923.field_41178.method_10221((Object)handStack.method_7909()).toString();
            if (holdItems.stream().map(ShoulderSurfingPlugin::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(handItemId))) {
                return true;
            }
            for (String string : list) {
                if (class_5272.method_27878((class_1799)handStack, (class_2960)class_2960.method_60654((String)string)) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static Predicate<String> expressionToMatchPredicate(String expression) {
        try {
            return Pattern.compile(expression).asMatchPredicate();
        }
        catch (Exception e) {
            return expression::equals;
        }
    }

    private static float getCameraEntityAlpha(IShoulderSurfing instance, class_1297 entity, float partialTick) {
        if (ShoulderSurfingPlugin.shouldRenderCameraEntityTransparent(instance, entity)) {
            class_243 renderOffset = instance.getCamera().getRenderOffset();
            float xAlpha = (float)class_3532.method_15350((double)(Math.abs(renderOffset.method_10216()) / ((double)entity.method_17681() / 2.0)), (double)0.0, (double)1.0);
            float yAlpha = 0.0f;
            if (renderOffset.method_10214() > 0.0) {
                yAlpha = (float)class_3532.method_15350((double)(renderOffset.method_10214() / (double)(entity.method_17682() - entity.method_5751())), (double)0.0, (double)1.0);
            } else if (renderOffset.method_10214() < 0.0) {
                yAlpha = (float)class_3532.method_15350((double)(-renderOffset.method_10214() / (double)(-entity.method_5751())), (double)0.0, (double)1.0);
            }
            return class_3532.method_15363((float)((float)Math.sqrt(xAlpha * xAlpha + yAlpha * yAlpha)), (float)0.15f, (float)1.0f);
        }
        return 1.0f;
    }

    private static boolean shouldRenderCameraEntityTransparent(IShoulderSurfing instance, class_1297 entity) {
        class_243 renderOffset = instance.getCamera().getRenderOffset();
        return !entity.method_7325() && Math.abs(renderOffset.method_10216()) < (double)entity.method_17681() / 2.0 && (renderOffset.method_10214() >= 0.0 && renderOffset.method_10214() < (double)(entity.method_17682() - entity.method_5751()) || renderOffset.method_10214() <= 0.0 && -renderOffset.method_10214() < (double)entity.method_5751());
    }

    private static class CameraEntityTransparencyCallbackWhenAiming
    implements ICameraEntityTransparencyCallback,
    ITickableCallback {
        private static final int TRANSITION_TICK_COUNT = 5;
        private int aimingTicks;
        private int aimingTicksO;

        private CameraEntityTransparencyCallbackWhenAiming() {
        }

        @Override
        public void tick() {
            if (Config.CLIENT.turnPlayerTransparentWhenAiming()) {
                this.aimingTicksO = this.aimingTicks;
                if (ShoulderSurfingImpl.getInstance().isAiming()) {
                    if (this.aimingTicks < 5) {
                        ++this.aimingTicks;
                    }
                } else if (this.aimingTicks > 0) {
                    --this.aimingTicks;
                }
            }
        }

        @Override
        public float getCameraEntityAlpha(IShoulderSurfing instance, class_1297 entity, float partialTick) {
            if (Config.CLIENT.turnPlayerTransparentWhenAiming()) {
                float f = (5.0f - class_3532.method_16439((float)partialTick, (float)this.aimingTicksO, (float)this.aimingTicks)) / 5.0f;
                return 0.15f + 0.85f * f;
            }
            return 1.0f;
        }
    }
}

