/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.ITickableCallback;
import com.github.exopandora.shouldersurfing.api.client.IClientConfig;
import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.CrosshairType;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.api.model.PickVector;
import com.github.exopandora.shouldersurfing.api.util.EntityHelper;
import com.github.exopandora.shouldersurfing.client.CameraEntityRenderer;
import com.github.exopandora.shouldersurfing.client.CrosshairRenderer;
import com.github.exopandora.shouldersurfing.client.InputHandler;
import com.github.exopandora.shouldersurfing.client.ObjectPicker;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.mixinducks.OptionsDuck;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import net.minecraft.class_9334;

public class ShoulderSurfingImpl
implements IShoulderSurfing {
    private final ShoulderSurfingCamera camera = new ShoulderSurfingCamera(this);
    private final CameraEntityRenderer playerRenderer = new CameraEntityRenderer(this);
    private final CrosshairRenderer crosshairRenderer = new CrosshairRenderer(this);
    private final ObjectPicker objectPicker = new ObjectPicker();
    private final InputHandler inputHandler = new InputHandler(this);
    private boolean isShoulderSurfing;
    private boolean isTemporaryFirstPerson;
    private boolean isAiming;
    private boolean isCameraDecoupled;
    private boolean isFreeLooking;
    private int turningLockTime;
    private boolean updatePlayerRotations;
    private float playerXRotO;
    private float playerYRotO;

    public void init() {
        Perspective targetPerspective = Config.CLIENT.getDefaultPerspective();
        if (!targetPerspective.isEnabled(Config.CLIENT)) {
            targetPerspective = targetPerspective.next(Config.CLIENT);
        }
        if (Perspective.current() != targetPerspective) {
            this.changePerspective(targetPerspective);
        }
    }

    public void tick() {
        boolean isFirstPerson;
        if (Config.CLIENT.requiresSaving()) {
            Config.CLIENT.save();
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1755 == null) {
            this.inputHandler.tick();
        }
        boolean bl = isFirstPerson = Perspective.FIRST_PERSON == Perspective.current();
        if (!isFirstPerson) {
            this.isTemporaryFirstPerson = false;
        }
        this.isAiming = ShoulderSurfingImpl.isHoldingAdaptiveItem(minecraft, minecraft.method_1560());
        this.updatePlayerRotations = false;
        class_746 player = minecraft.field_1724;
        if (this.isShoulderSurfing && Config.CLIENT.getCrosshairType().doSwitchPerspective(this.isAiming)) {
            this.changePerspective(Perspective.FIRST_PERSON);
            this.isTemporaryFirstPerson = true;
        } else if (this.isTemporaryFirstPerson && isFirstPerson && !Config.CLIENT.getCrosshairType().doSwitchPerspective(this.isAiming)) {
            this.changePerspective(Perspective.SHOULDER_SURFING);
        }
        boolean bl2 = this.isCameraDecoupled = this.isShoulderSurfing && Config.CLIENT.isCameraDecoupled() && !ShoulderSurfingImpl.isForcingCoupledCamera(minecraft);
        if (this.isShoulderSurfing && player != null) {
            boolean isTurningLockActive;
            boolean bl3 = isTurningLockActive = this.turningLockTime > 0;
            if (isTurningLockActive && !this.isCameraDecoupled()) {
                this.turningLockTime = 0;
            }
            this.isFreeLooking = InputHandler.FREE_LOOK.method_1434() && !this.isAiming;
            this.camera.tick();
            if (!this.isFreeLooking && minecraft.method_1560() == player) {
                boolean shouldAimAtTarget = this.shouldEntityAimAtTargetInternal((class_1309)player, minecraft);
                if (shouldAimAtTarget || isTurningLockActive) {
                    this.turningLockTime = shouldAimAtTarget ? Config.CLIENT.getTurningLockTime() : this.turningLockTime - 1;
                    this.lookAtCrosshairTargetInternal();
                } else if (this.shouldEntityFollowCamera((class_1309)player)) {
                    player.method_36457(this.camera.getXRot());
                    player.method_36456(this.camera.getYRot());
                }
            }
        }
        ShoulderSurfingRegistrar.getInstance().getTickableCallbacks().forEach(ITickableCallback::tick);
    }

    public void lookAtCrosshairTarget() {
        this.turningLockTime = Config.CLIENT.getTurningLockTime();
        this.lookAtCrosshairTargetInternal();
    }

    private void lookAtCrosshairTargetInternal() {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        assert (player != null);
        class_4184 camera = minecraft.field_1773.method_19418();
        double interactionRange = Config.CLIENT.getCrosshairType().isAimingDecoupled() ? 400.0 : Config.CLIENT.getCustomRaytraceDistance();
        PickContext pickContext = new PickContext.Builder(camera).build();
        class_239 hitResult = this.objectPicker.pick(pickContext, interactionRange, 1.0f, (class_1657)player);
        this.playerXRotO = player.method_36455();
        this.playerYRotO = player.method_36454();
        this.updatePlayerRotations = true;
        EntityHelper.lookAtTarget(player, hitResult.method_17784());
        this.camera.setLastMovedYRot(player.method_36454());
    }

    public void updatePlayerRotations() {
        class_746 player = class_310.method_1551().field_1724;
        if (this.updatePlayerRotations && player != null) {
            player.field_6004 = this.playerXRotO;
            player.field_5982 = this.playerYRotO;
        }
    }

    private boolean shouldEntityAimAtTargetInternal(class_1309 cameraEntity, class_310 minecraft) {
        class_1657 player;
        return this.isAiming && Config.CLIENT.getCrosshairType().isAimingDecoupled() || !this.isAiming && this.isCameraDecoupled() && (ShoulderSurfingImpl.isUsingItem(cameraEntity, minecraft) || !cameraEntity.method_6128() && (ShoulderSurfingImpl.isInteracting(cameraEntity, minecraft) && (Config.CLIENT.getPickVector() != PickVector.PLAYER || Config.CLIENT.getCrosshairType() != CrosshairType.DYNAMIC) || ShoulderSurfingImpl.isAttacking(minecraft) || ShoulderSurfingImpl.isPicking(minecraft) || cameraEntity instanceof class_1657 && (player = (class_1657)cameraEntity).method_31550()));
    }

    public boolean shouldEntityAimAtTarget(class_1309 cameraEntity, class_310 minecraft) {
        return this.turningLockTime > 0 || this.shouldEntityAimAtTargetInternal(cameraEntity, minecraft);
    }

    public boolean isEntityRotationDecoupled(class_1309 cameraEntity, class_310 minecraft) {
        return !this.shouldEntityAimAtTarget(cameraEntity, minecraft) && !this.shouldEntityFollowCamera(cameraEntity);
    }

    private static boolean isUsingItem(class_1309 cameraEntity, class_310 minecraft) {
        return cameraEntity.method_6115() && Config.CLIENT.getTurningModeWhenUsingItem().shouldTurn(minecraft.field_1765) && !cameraEntity.method_6030().method_57826(class_9334.field_50075);
    }

    private static boolean isInteracting(class_1309 cameraEntity, class_310 minecraft) {
        return minecraft.field_1690.field_1904.method_1434() && !cameraEntity.method_6115() && Config.CLIENT.getTurningModeWhenInteracting().shouldTurn(minecraft.field_1765);
    }

    private static boolean isAttacking(class_310 minecraft) {
        return minecraft.field_1690.field_1886.method_1434() && Config.CLIENT.getTurningModeWhenAttacking().shouldTurn(minecraft.field_1765);
    }

    private static boolean isPicking(class_310 minecraft) {
        return minecraft.field_1690.field_1871.method_1434() && Config.CLIENT.getTurningModeWhenPicking().shouldTurn(minecraft.field_1765);
    }

    public boolean shouldEntityFollowCamera(class_1309 cameraEntity) {
        return this.isAiming && !Config.CLIENT.getCrosshairType().isAimingDecoupled() || cameraEntity.method_6128() || !this.isCameraDecoupled();
    }

    private static boolean isHoldingAdaptiveItem(class_310 minecraft, class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            return ShoulderSurfingRegistrar.getInstance().getAdaptiveItemCallbacks().stream().anyMatch(callback -> callback.isHoldingAdaptiveItem(minecraft, living));
        }
        return false;
    }

    private static boolean isForcingCoupledCamera(class_310 minecraft) {
        return ShoulderSurfingRegistrar.getInstance().getCameraCouplingCallbacks().stream().anyMatch(callback -> callback.isForcingCameraCoupling(minecraft));
    }

    @Override
    public void changePerspective(Perspective perspective) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        boolean wasShoulderSurfing = this.isShoulderSurfing;
        boolean isShoulderSurfing = perspective == Perspective.SHOULDER_SURFING;
        boolean isEnteringShoulderSurfing = !wasShoulderSurfing && isShoulderSurfing;
        boolean isExitingShoulderSurfing = wasShoulderSurfing && !isShoulderSurfing;
        class_1297 cameraEntity = minecraft.method_1560();
        if (isExitingShoulderSurfing && player != null && cameraEntity == player) {
            this.lookAtCrosshairTargetInternal();
        }
        ((OptionsDuck)minecraft.field_1690).shouldersurfing$setCameraTypeDirect(perspective.getCameraType());
        this.isShoulderSurfing = isShoulderSurfing;
        if (minecraft.field_1687 != null) {
            minecraft.field_1769.method_3292();
        }
        if (isEnteringShoulderSurfing) {
            this.resetState();
        }
    }

    @Override
    public void togglePerspective() {
        class_310 minecraft = class_310.method_1551();
        Perspective current = Perspective.current();
        Perspective next = current.next(Config.CLIENT);
        this.changePerspective(next);
        boolean isFirstPerson = next.getCameraType().method_31034();
        if (current.getCameraType().method_31034() != isFirstPerson) {
            minecraft.field_1773.method_3167(isFirstPerson ? minecraft.method_1560() : null);
        }
        if (Config.CLIENT.doRememberLastPerspective()) {
            Config.CLIENT.setDefaultPerspective(next);
        }
    }

    public void toggleCameraCoupling() {
        Config.CLIENT.toggleCameraCoupling();
    }

    public void toggleOffsetXPreset() {
        Config.CLIENT.toggleOffsetXPreset();
    }

    public void toggleOffsetYPreset() {
        Config.CLIENT.toggleOffsetYPreset();
    }

    public void toggleOffsetZPreset() {
        Config.CLIENT.toggleOffsetZPreset();
    }

    public boolean isTemporaryFirstPerson() {
        return this.isTemporaryFirstPerson;
    }

    @Override
    public void swapShoulder() {
        Config.CLIENT.swapShoulder();
    }

    @Override
    public boolean isShoulderSurfing() {
        return this.isShoulderSurfing;
    }

    @Override
    public boolean isAiming() {
        return this.isAiming;
    }

    @Override
    public boolean isCameraDecoupled() {
        return this.isCameraDecoupled;
    }

    @Override
    public boolean isFreeLooking() {
        return this.isFreeLooking && this.isShoulderSurfing;
    }

    @Override
    public ShoulderSurfingCamera getCamera() {
        return this.camera;
    }

    @Override
    public CameraEntityRenderer getCameraEntityRenderer() {
        return this.playerRenderer;
    }

    @Override
    public CrosshairRenderer getCrosshairRenderer() {
        return this.crosshairRenderer;
    }

    @Override
    public ObjectPicker getObjectPicker() {
        return this.objectPicker;
    }

    @Override
    public IClientConfig getClientConfig() {
        return Config.CLIENT;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public void resetState() {
        this.camera.resetState();
        this.crosshairRenderer.resetState();
        this.turningLockTime = 0;
    }

    public static ShoulderSurfingImpl getInstance() {
        return (ShoulderSurfingImpl)ShoulderSurfing.getInstance();
    }
}

