/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import com.github.exopandora.shouldersurfing.api.client.IClientConfig;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.CrosshairVisibility;
import net.minecraft.class_310;
import net.minecraft.class_5498;

public enum Perspective {
    FIRST_PERSON(class_5498.field_26664, CrosshairVisibility.ALWAYS),
    THIRD_PERSON_BACK(class_5498.field_26665, CrosshairVisibility.NEVER),
    THIRD_PERSON_FRONT(class_5498.field_26666, CrosshairVisibility.NEVER),
    SHOULDER_SURFING(class_5498.field_26665, CrosshairVisibility.ALWAYS);

    private final class_5498 cameraType;
    private final CrosshairVisibility defaultCrosshairVisibility;

    private Perspective(class_5498 cameraType, CrosshairVisibility defaultCrosshairVisibility) {
        this.cameraType = cameraType;
        this.defaultCrosshairVisibility = defaultCrosshairVisibility;
    }

    public class_5498 getCameraType() {
        return this.cameraType;
    }

    public CrosshairVisibility getDefaultCrosshairVisibility() {
        return this.defaultCrosshairVisibility;
    }

    public Perspective next(IClientConfig config) {
        Perspective next;
        if (config.replaceDefaultPerspective()) {
            next = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> SHOULDER_SURFING;
                case 2 -> FIRST_PERSON;
                case 3 -> THIRD_PERSON_FRONT;
            };
        } else {
            next = Perspective.values()[(this.ordinal() + 1) % Perspective.values().length];
        }
        switch (next.ordinal()) {
            case 0: {
                if (!config.isFirstPersonEnabled()) break;
                return FIRST_PERSON;
            }
            case 1: {
                if (!config.isThirdPersonBackEnabled()) break;
                return THIRD_PERSON_BACK;
            }
            case 2: {
                if (!config.isThirdPersonFrontEnabled()) break;
                return THIRD_PERSON_FRONT;
            }
            case 3: {
                return SHOULDER_SURFING;
            }
        }
        return next.next(config);
    }

    public boolean isEnabled(IClientConfig config) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> config.isFirstPersonEnabled();
            case 1 -> {
                if (config.isThirdPersonBackEnabled() && !config.replaceDefaultPerspective()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> config.isThirdPersonFrontEnabled();
            case 3 -> true;
        };
    }

    public static Perspective of(class_5498 cameraType, boolean shoulderSurfing) {
        return switch (cameraType) {
            default -> throw new MatchException(null, null);
            case class_5498.field_26664 -> FIRST_PERSON;
            case class_5498.field_26665 -> {
                if (shoulderSurfing) {
                    yield SHOULDER_SURFING;
                }
                yield THIRD_PERSON_BACK;
            }
            case class_5498.field_26666 -> THIRD_PERSON_FRONT;
        };
    }

    public static Perspective current() {
        return Perspective.of(class_310.method_1551().field_1690.method_31044(), ShoulderSurfing.getInstance().isShoulderSurfing());
    }
}

