/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.Couple;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.api.model.PickOrigin;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4184;

public final class OffsetPickContext
extends PickContext {
    private final PickOrigin blockPickOrigin;
    private final PickOrigin entityPickOrigin;

    public OffsetPickContext(class_4184 camera, class_3959.class_242 fluidContext, class_1297 entity, Predicate<class_1297> entityFilter, PickOrigin blockPickOrigin, PickOrigin entityPickOrigin) {
        super(camera, fluidContext, entity, entityFilter);
        this.blockPickOrigin = blockPickOrigin;
        this.entityPickOrigin = entityPickOrigin;
    }

    @Override
    public class_3959.class_3960 blockContext() {
        IShoulderSurfing instance = ShoulderSurfing.getInstance();
        if (instance.isAiming() || instance.getCrosshairRenderer().isCrosshairDynamic(this.entity())) {
            return class_3959.class_3960.field_17558;
        }
        return class_3959.class_3960.field_17559;
    }

    @Override
    public Couple<class_243> entityTrace(double interactionRange, float partialTick) {
        return OffsetPickContext.calcRay(this.camera(), this.entity(), interactionRange, partialTick, this.entityPickOrigin);
    }

    @Override
    public Couple<class_243> blockTrace(double interactionRange, float partialTick) {
        return OffsetPickContext.calcRay(this.camera(), this.entity(), interactionRange, partialTick, this.blockPickOrigin);
    }

    private static Couple<class_243> calcRay(class_4184 camera, class_1297 entity, double interactionRange, float partialTick, PickOrigin pickOrigin) {
        class_243 eyePosition = entity.method_5836(partialTick);
        class_243 cameraPos = camera.method_19326();
        class_243 cameraOffset = cameraPos.method_1020(eyePosition);
        class_243 renderOffset = ShoulderSurfing.getInstance().getCamera().getRenderOffset();
        class_243 rayTraceStartOffset = new class_243(camera.method_35689()).method_1021(renderOffset.method_10216()).method_1019(new class_243(camera.method_19336()).method_1021(renderOffset.method_10214()));
        class_243 viewVector = new class_243(camera.method_19335());
        double interactionRangeSq = class_3532.method_33723((double)interactionRange);
        if (rayTraceStartOffset.method_1027() < interactionRangeSq) {
            interactionRange = Math.sqrt(interactionRangeSq - rayTraceStartOffset.method_1027());
        }
        double distance = interactionRange + cameraOffset.method_1022(rayTraceStartOffset);
        class_243 startPos = pickOrigin.calc(cameraPos, eyePosition, rayTraceStartOffset);
        class_243 endPos = cameraPos.method_1019(viewVector.method_1021(distance));
        return new Couple<class_243>(startPos, endPos);
    }
}

