/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.ListOptionEntry;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.TooltipButtonWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class ListEntryWidget
extends AbstractWidget
implements class_4069 {
    private final TooltipButtonWidget removeButton;
    private final TooltipButtonWidget moveUpButton;
    private final TooltipButtonWidget moveDownButton;
    private final AbstractWidget entryWidget;
    private final ListOption<?> listOption;
    private final ListOptionEntry<?> listOptionEntry;
    private final String optionNameString;
    private class_364 focused;
    private boolean dragging;

    public ListEntryWidget(YACLScreen screen, ListOptionEntry<?> listOptionEntry, AbstractWidget entryWidget) {
        super(entryWidget.getDimension().withHeight(Math.min(entryWidget.getDimension().height(), 20) - (listOptionEntry.parentGroup().indexOf(listOptionEntry) == listOptionEntry.parentGroup().options().size() - 1 ? 0 : 2)));
        this.listOptionEntry = listOptionEntry;
        this.listOption = listOptionEntry.parentGroup();
        this.optionNameString = listOptionEntry.name().getString().toLowerCase();
        this.entryWidget = entryWidget;
        Dimension<Integer> dim = entryWidget.getDimension();
        entryWidget.setDimension(dim.clone().move(40, 0).expand(-60, 0));
        this.removeButton = new TooltipButtonWidget(screen, dim.xLimit() - 20, dim.y(), 20, 20, (class_2561)class_2561.method_43470((String)"\u274c"), (class_2561)class_2561.method_43471((String)"yacl.list.remove"), btn -> {
            this.listOption.removeEntry(listOptionEntry);
            this.updateButtonStates();
        });
        this.moveUpButton = new TooltipButtonWidget(screen, dim.x(), dim.y(), 20, 20, (class_2561)class_2561.method_43470((String)"\u2191"), (class_2561)class_2561.method_43471((String)"yacl.list.move_up"), btn -> {
            int index = this.listOption.indexOf(listOptionEntry) - 1;
            if (index >= 0) {
                this.listOption.removeEntry(listOptionEntry);
                this.listOption.insertEntry(index, listOptionEntry);
                this.updateButtonStates();
            }
        });
        this.moveDownButton = new TooltipButtonWidget(screen, dim.x() + 20, dim.y(), 20, 20, (class_2561)class_2561.method_43470((String)"\u2193"), (class_2561)class_2561.method_43471((String)"yacl.list.move_down"), btn -> {
            int index = this.listOption.indexOf(listOptionEntry) + 1;
            if (index < this.listOption.options().size()) {
                this.listOption.removeEntry(listOptionEntry);
                this.listOption.insertEntry(index, listOptionEntry);
                this.updateButtonStates();
            }
        });
        this.updateButtonStates();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.updateButtonStates();
        this.removeButton.method_46419(this.getDimension().y());
        this.moveUpButton.method_46419(this.getDimension().y());
        this.moveDownButton.method_46419(this.getDimension().y());
        this.entryWidget.setDimension(this.entryWidget.getDimension().withY(this.getDimension().y()));
        this.removeButton.method_25394(graphics, mouseX, mouseY, delta);
        this.moveUpButton.method_25394(graphics, mouseX, mouseY, delta);
        this.moveDownButton.method_25394(graphics, mouseX, mouseY, delta);
        this.entryWidget.method_25394(graphics, mouseX, mouseY, delta);
    }

    protected void updateButtonStates() {
        this.removeButton.field_22763 = this.listOption.available() && this.listOption.numberOfEntries() > this.listOption.minimumNumberOfEntries();
        this.moveUpButton.field_22763 = this.listOption.indexOf(this.listOptionEntry) > 0 && this.listOption.available();
        this.moveDownButton.field_22763 = this.listOption.indexOf(this.listOptionEntry) < this.listOption.options().size() - 1 && this.listOption.available();
    }

    @Override
    public void unfocus() {
        this.entryWidget.unfocus();
    }

    @Override
    public void method_37020(class_6382 builder) {
        this.entryWidget.method_37020(builder);
    }

    @Override
    public boolean matchesSearch(String query) {
        return this.optionNameString.contains(query.toLowerCase());
    }

    public List<? extends class_364> method_25396() {
        return ImmutableList.of((Object)((Object)this.moveUpButton), (Object)((Object)this.moveDownButton), (Object)this.entryWidget, (Object)((Object)this.removeButton));
    }

    public boolean method_25397() {
        return this.dragging;
    }

    public void method_25398(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public class_364 method_25399() {
        return this.focused;
    }

    public void method_25395(@Nullable class_364 focused) {
        this.focused = focused;
    }
}

