/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.utils;

import ca.fxco.moreculling.api.data.QuadBounds;
import ca.fxco.moreculling.api.sprite.SpriteOpacity;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import org.jetbrains.annotations.Nullable;

public class SpriteUtils {
    public static boolean doesHaveTransparency(class_1058 sprite) {
        int width = sprite.method_45851().method_45807();
        int height = sprite.method_45851().method_45815();
        for (int frame : sprite.method_45851().method_45817().toArray()) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!sprite.method_45851().method_45810(frame, x, y)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesHaveTransparency(class_1058 sprite, QuadBounds bounds) {
        int minWidth = Math.max(0, bounds.getMinX());
        int minHeight = Math.max(0, bounds.getMinY());
        int maxWidth = Math.min(bounds.getMaxX(), sprite.method_45851().method_45807());
        int maxHeight = Math.min(bounds.getMaxY(), sprite.method_45851().method_45815());
        for (int frame : sprite.method_45851().method_45817().toArray()) {
            for (int y = minHeight; y < maxHeight; ++y) {
                for (int x = minWidth; x < maxWidth; ++x) {
                    if (!sprite.method_45851().method_45810(frame, x, y)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesHaveTransparency(class_1011 nativeImage) {
        if (nativeImage.method_4318().method_4329()) {
            int width = nativeImage.method_4307();
            for (int y = 0; y < nativeImage.method_4323(); ++y) {
                for (int x = 0; x < width; ++x) {
                    if (nativeImage.method_4311(x, y) != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesHaveTransparency(class_1011 nativeImage, QuadBounds bounds) {
        if (nativeImage.method_4318().method_4329()) {
            int minWidth = Math.max(0, bounds.getMinX());
            int maxWidth = Math.min(bounds.getMaxX(), nativeImage.method_4307());
            for (int y = Math.max(0, bounds.getMinY()); y < Math.min(bounds.getMaxY(), nativeImage.method_4323()); ++y) {
                for (int x = minWidth; x < maxWidth; ++x) {
                    if (nativeImage.method_4311(x, y) != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesHaveTranslucency(class_1011 image, @Nullable List<class_1011> orMatch) {
        return SpriteUtils.doesHaveTranslucency(image, orMatch, 0, image.method_4307(), 0, image.method_4323());
    }

    public static boolean doesHaveTranslucency(class_1011 image, QuadBounds bounds, @Nullable List<class_1011> orMatch) {
        return SpriteUtils.doesHaveTranslucency(image, orMatch, Math.max(0, bounds.getMinX()), Math.min(bounds.getMaxX(), image.method_4307()), Math.max(0, bounds.getMinY()), Math.min(bounds.getMaxY(), image.method_4323()));
    }

    private static boolean doesHaveTranslucency(class_1011 image, @Nullable List<class_1011> orMatch, int minWidth, int maxWidth, int minHeight, int maxHeight) {
        if (image.method_4318().method_4329()) {
            for (int y = minHeight; y < maxHeight; ++y) {
                for (int x = minWidth; x < maxWidth; ++x) {
                    if (image.method_4311(x, y) == -1) continue;
                    if (orMatch != null) {
                        boolean success = false;
                        for (class_1011 nativeImage : orMatch) {
                            if (x > nativeImage.method_4307() || y > nativeImage.method_4323() || nativeImage.method_4311(x, y) != -1) continue;
                            success = true;
                            break;
                        }
                        if (success) continue;
                        return true;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static void printOpacity(class_1058 sprite) {
        SpriteUtils.printOpacity(sprite, null);
    }

    public static void printOpacity(class_1058 sprite, @Nullable QuadBounds bounds) {
        class_1011 img = ((SpriteOpacity)sprite).moreculling$getUnmipmappedImage();
        if (img.method_4318().method_4337()) {
            SpriteUtils.printOpacity(img, bounds);
        }
    }

    public static void printOpacity(class_1011 nativeImage, @Nullable QuadBounds bounds) {
        if (!nativeImage.method_4318().method_4337()) {
            return;
        }
        int minWidth = bounds == null ? 0 : Math.max(0, bounds.getMinX());
        int maxWidth = bounds == null ? nativeImage.method_4307() : Math.min(bounds.getMaxX(), nativeImage.method_4307());
        int minHeight = bounds == null ? 0 : Math.max(0, bounds.getMinY());
        int maxHeight = bounds == null ? nativeImage.method_4323() : Math.min(bounds.getMaxY(), nativeImage.method_4323());
        for (int y = minHeight; y < maxHeight; ++y) {
            StringBuilder line = new StringBuilder();
            for (int x = minWidth; x < maxWidth; ++x) {
                line.append(String.format("%4d" + (x != maxWidth - 1 ? "," : ""), nativeImage.method_4311(x, y)));
            }
            System.out.println(line);
        }
    }
}

