/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.core.discord;

import com.hypherionmc.craterlib.core.rpcsdk.DiscordEventHandlers;
import com.hypherionmc.craterlib.core.rpcsdk.DiscordRPC;
import com.hypherionmc.craterlib.core.rpcsdk.DiscordRichPresence;
import java.util.concurrent.TimeUnit;
import me.hypherionmc.simplerpc.core.RPCConstants;
import me.hypherionmc.simplerpc.core.configuration.ClientConfig;
import me.hypherionmc.simplerpc.core.discord.RichPresenceCore;

public class DiscordController {
    private final DiscordRPC discordRPC;
    private final ClientConfig clientConfig;

    public DiscordController(ClientConfig clientConfig) {
        block2: {
            this.clientConfig = clientConfig;
            this.discordRPC = DiscordRPC.INSTANCE;
            try {
                DiscordEventHandlers handlers = new DiscordEventHandlers.Builder().ready(ready -> RPCConstants.logger.info("Connected to discord as {}", (Object)ready.username)).disconnected((s1, s2) -> RPCConstants.logger.error("Disconnected from discord with error {}, {}", (Object)s1, (Object)s2)).errored((s1, s2) -> RPCConstants.logger.error("Discord RPC error {}, {}", (Object)s1, (Object)s2)).build();
                this.discordRPC.Discord_Initialize(String.valueOf(clientConfig.general.discordid), handlers, false, "");
                RichPresenceCore.taskManager.scheduleAtFixedRate(() -> ((DiscordRPC)this.discordRPC).Discord_RunCallbacks(), 0L, 500L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (clientConfig == null || !clientConfig.general.debugging) break block2;
                RPCConstants.logger.error("Failed to connect to discord", (Throwable)e);
            }
        }
    }

    public void updateRichPresence(DiscordRichPresence presence) {
        block5: {
            try {
                if (this.discordRPC != null) {
                    if (presence == null) {
                        this.discordRPC.Discord_ClearPresence();
                    } else {
                        this.discordRPC.Discord_UpdatePresence(presence);
                    }
                }
            }
            catch (Exception e) {
                if (this.clientConfig == null || !this.clientConfig.general.debugging) break block5;
                RPCConstants.logger.error("Failed to update Rich Presence", (Throwable)e);
            }
        }
    }

    public void shutdownRichPresence() {
        if (this.discordRPC != null) {
            this.discordRPC.Discord_ClearPresence();
            this.discordRPC.Discord_Shutdown();
        }
    }
}

