/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.serverbound;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.serverbound.ServerPacketTcpHandler;

public final class PlayerActivationDistancesPacket
implements Packet<ServerPacketTcpHandler> {
    private Map<UUID, Integer> distanceByActivationId;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.distanceByActivationId = Maps.newHashMap();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.distanceByActivationId.put(PacketUtil.readUUID(in), in.readInt());
        }
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        out.writeInt(((Map)Preconditions.checkNotNull(this.distanceByActivationId)).size());
        this.distanceByActivationId.forEach((activationId, distance) -> {
            PacketUtil.writeUUID(out, activationId);
            out.writeInt(distance.intValue());
        });
    }

    @Override
    public void handle(ServerPacketTcpHandler handler) {
        handler.handle(this);
    }

    public PlayerActivationDistancesPacket(Map<UUID, Integer> distanceByActivationId) {
        this.distanceByActivationId = distanceByActivationId;
    }

    public PlayerActivationDistancesPacket() {
    }

    public String toString() {
        return "PlayerActivationDistancesPacket(distanceByActivationId=" + this.getDistanceByActivationId() + ")";
    }

    public Map<UUID, Integer> getDistanceByActivationId() {
        return this.distanceByActivationId;
    }
}

