/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.meta;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.client.meta.Patron;
import su.plo.voice.client.meta.developer.Developer;
import su.plo.voice.client.meta.developer.DeveloperRole;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.ResultKt;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.coroutines.Continuation;
import su.plo.voice.libs.kotlin.coroutines.intrinsics.IntrinsicsKt;
import su.plo.voice.libs.kotlin.io.CloseableKt;
import su.plo.voice.libs.kotlin.io.TextStreamsKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function2;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.text.Charsets;
import su.plo.voice.libs.kotlin.time.Duration;
import su.plo.voice.libs.kotlinx.coroutines.BuildersKt;
import su.plo.voice.libs.kotlinx.coroutines.CoroutineScope;
import su.plo.voice.util.CoroutineScopes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lsu/plo/voice/client/meta/PlasmoVoiceMeta;", "", "developers", "", "Lsu/plo/voice/client/meta/developer/Developer;", "patrons", "Lsu/plo/voice/client/meta/Patron;", "lastUpdateMs", "", "<init>", "(Ljava/util/List;Ljava/util/List;J)V", "getDevelopers", "()Ljava/util/List;", "getPatrons", "getLastUpdateMs", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "plasmovoice-fabric-1.21"})
public final class PlasmoVoiceMeta {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Developer> developers;
    @NotNull
    private final List<Patron> patrons;
    private final long lastUpdateMs;
    @NotNull
    private static final PlasmoVoiceMeta defaultMeta;
    @NotNull
    private static PlasmoVoiceMeta meta;
    @NotNull
    private static final Map<String, PlasmoVoiceMeta> metaByLanguage;
    @NotNull
    private static final File cacheFile;
    @NotNull
    private static final Gson gson;
    private static final Type cacheType;

    public PlasmoVoiceMeta(@NotNull List<Developer> developers2, @NotNull List<Patron> patrons2, long lastUpdateMs) {
        Intrinsics.checkNotNullParameter(developers2, "developers");
        Intrinsics.checkNotNullParameter(patrons2, "patrons");
        this.developers = developers2;
        this.patrons = patrons2;
        this.lastUpdateMs = lastUpdateMs;
    }

    @NotNull
    public final List<Developer> getDevelopers() {
        return this.developers;
    }

    @NotNull
    public final List<Patron> getPatrons() {
        return this.patrons;
    }

    public final long getLastUpdateMs() {
        return this.lastUpdateMs;
    }

    @NotNull
    public final List<Developer> component1() {
        return this.developers;
    }

    @NotNull
    public final List<Patron> component2() {
        return this.patrons;
    }

    public final long component3() {
        return this.lastUpdateMs;
    }

    @NotNull
    public final PlasmoVoiceMeta copy(@NotNull List<Developer> developers2, @NotNull List<Patron> patrons2, long lastUpdateMs) {
        Intrinsics.checkNotNullParameter(developers2, "developers");
        Intrinsics.checkNotNullParameter(patrons2, "patrons");
        return new PlasmoVoiceMeta(developers2, patrons2, lastUpdateMs);
    }

    public static /* synthetic */ PlasmoVoiceMeta copy$default(PlasmoVoiceMeta plasmoVoiceMeta, List list, List list2, long l, int n, Object object) {
        if ((n & 1) != 0) {
            list = plasmoVoiceMeta.developers;
        }
        if ((n & 2) != 0) {
            list2 = plasmoVoiceMeta.patrons;
        }
        if ((n & 4) != 0) {
            l = plasmoVoiceMeta.lastUpdateMs;
        }
        return plasmoVoiceMeta.copy(list, list2, l);
    }

    @NotNull
    public String toString() {
        return "PlasmoVoiceMeta(developers=" + this.developers + ", patrons=" + this.patrons + ", lastUpdateMs=" + this.lastUpdateMs + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.developers).hashCode();
        result2 = result2 * 31 + ((Object)this.patrons).hashCode();
        result2 = result2 * 31 + Long.hashCode(this.lastUpdateMs);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlasmoVoiceMeta)) {
            return false;
        }
        PlasmoVoiceMeta plasmoVoiceMeta = (PlasmoVoiceMeta)other;
        if (!Intrinsics.areEqual(this.developers, plasmoVoiceMeta.developers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.patrons, plasmoVoiceMeta.patrons)) {
            return false;
        }
        return this.lastUpdateMs == plasmoVoiceMeta.lastUpdateMs;
    }

    static {
        Developer[] developerArray = new Developer[3];
        UUID uUID = UUID.fromString("2714d55f-ffef-4655-a93e-d8ca13230e76");
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        developerArray[0] = new Developer(uUID, "KPidS", DeveloperRole.HUIX, "Twitch", "https://twitch.tv/kpids", CollectionsKt.listOf("CoolStory_Bob"));
        UUID uUID2 = UUID.fromString("8f552657-df1d-42cd-89c6-c176e195f703");
        Intrinsics.checkNotNullExpressionValue(uUID2, "fromString(...)");
        developerArray[1] = new Developer(uUID2, "Apehum", DeveloperRole.PROGRAMMING, "Telegram", "https://t.me/arehum", CollectionsKt.listOf("GNOME__"));
        UUID uUID3 = UUID.fromString("cfb727e7-efcc-4596-8c2b-9c6e38c8eea4");
        Intrinsics.checkNotNullExpressionValue(uUID3, "fromString(...)");
        developerArray[2] = new Developer(uUID3, "Venterok", DeveloperRole.ARTIST, "Telegram", "https://t.me/venterrok", null, 32, null);
        meta = defaultMeta = new PlasmoVoiceMeta(CollectionsKt.listOf(developerArray), CollectionsKt.emptyList(), 0L);
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        metaByLanguage = concurrentMap;
        cacheFile = new File("config/plasmovoice/meta_cache.json");
        gson = new Gson();
        cacheType = new TypeToken<Map<String, ? extends PlasmoVoiceMeta>>(){}.getType();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fJ\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lsu/plo/voice/client/meta/PlasmoVoiceMeta$Companion;", "", "<init>", "()V", "META", "Lsu/plo/voice/client/meta/PlasmoVoiceMeta;", "getMETA", "()Lsu/plo/voice/client/meta/PlasmoVoiceMeta;", "defaultMeta", "meta", "metaByLanguage", "", "", "cacheFile", "Ljava/io/File;", "gson", "Lcom/google/gson/Gson;", "cacheType", "Ljava/lang/reflect/Type;", "su.plo.voice.libs.kotlin.jvm.PlatformType", "Ljava/lang/reflect/Type;", "fetch", "", "languageName", "fetchOrLoadSync", "fetchSync", "loadCache", "saveCache", "plasmovoice-fabric-1.21"})
    @SourceDebugExtension(value={"SMAP\nPlasmoVoiceMeta.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlasmoVoiceMeta.kt\nsu/plo/voice/client/meta/PlasmoVoiceMeta$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlasmoVoiceMeta getMETA() {
            return meta;
        }

        public final void fetch(@NotNull String languageName) {
            Intrinsics.checkNotNullParameter(languageName, "languageName");
            BuildersKt.launch$default(CoroutineScopes.INSTANCE.getDefaultSupervisor(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(languageName, null){
                int label;
                final /* synthetic */ String $languageName;
                {
                    this.$languageName = $languageName;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            su.plo.voice.client.meta.PlasmoVoiceMeta$Companion.access$fetchOrLoadSync(PlasmoVoiceMeta.Companion, this.$languageName);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }

        private final void fetchOrLoadSync(String languageName) {
            PlasmoVoiceMeta meta;
            if (metaByLanguage.isEmpty()) {
                this.loadCache();
            }
            if ((meta = (PlasmoVoiceMeta)metaByLanguage.get(languageName)) == null || System.currentTimeMillis() - meta.getLastUpdateMs() > Duration.getInWholeMilliseconds-impl(Duration.Companion.parse-UwyO8pc("1d"))) {
                meta = this.fetchSync(languageName);
                metaByLanguage.put(languageName, meta);
                this.saveCache();
            }
            meta = meta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PlasmoVoiceMeta fetchSync(String languageName) {
            URLConnection connection;
            URL url = new URL("https://plasmovoice.com/meta.json?language=" + languageName);
            try {
                connection = url.openConnection();
                connection.addRequestProperty("User-Agent", "Plasmo Voice 2.1.6");
                connection.setConnectTimeout(3000);
                Gson gson = gson;
                InputStream inputStream = connection.getInputStream();
                Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                Gson gson2 = gson;
                object = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object2 = TextStreamsKt.readText(it);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally(closeable, (Throwable)object);
                }
                connection = ((JsonElement)gson2.fromJson((String)object2, JsonElement.class)).getAsJsonObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                return defaultMeta;
            }
            URLConnection metaJson = connection;
            Object object = gson.fromJson(metaJson.get("developers"), new TypeToken<List<? extends Developer>>(){}.getType());
            Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
            List developers2 = (List)object;
            Object object3 = gson.fromJson(metaJson.get("patrons"), new TypeToken<List<? extends Patron>>(){}.getType());
            Intrinsics.checkNotNullExpressionValue(object3, "fromJson(...)");
            List patrons2 = (List)object3;
            return new PlasmoVoiceMeta(developers2, patrons2, System.currentTimeMillis());
        }

        private final synchronized void loadCache() {
            Map map2;
            if (!cacheFile.exists()) {
                return;
            }
            try {
                File file = cacheFile;
                Charset charset = Charsets.UTF_8;
                int n = 8192;
                Object object = file;
                object = new InputStreamReader((InputStream)new FileInputStream((File)object), charset);
                Map map3 = (Map)gson.fromJson((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)), cacheType);
                if (map3 == null) {
                    return;
                }
                map2 = map3;
            }
            catch (Exception exception) {
                return;
            }
            Map cache2 = map2;
            metaByLanguage.putAll(cache2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final synchronized void saveCache() {
            cacheFile.getParentFile().mkdirs();
            Object object = cacheFile;
            Object object2 = Charsets.UTF_8;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                OutputStreamWriter it = (OutputStreamWriter)object;
                boolean bl = false;
                gson.toJson((Object)metaByLanguage, (Appendable)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }

        public static final /* synthetic */ void access$fetchOrLoadSync(Companion $this, String languageName) {
            $this.fetchOrLoadSync(languageName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

