/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.Inputs;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.ModVoiceClient;

public final class ScreenWrapper
extends class_437 {
    private final GuiScreen screen;
    private boolean ignoreFirstMove = true;
    @Nullable
    private class_332 currentContext;
    private int lastMouseX;
    private int lastMouseY;
    private float lastPartialTicks;

    public static void openScreen(@Nullable GuiScreen screen) {
        ScreenWrapper wrapped;
        if (screen == null) {
            class_310.method_1551().execute(() -> class_310.method_1551().method_1507(null));
            return;
        }
        wrapped.screen.screen = wrapped = new ScreenWrapper(screen);
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)wrapped));
    }

    public static Optional<ScreenWrapper> getCurrentWrappedScreen() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof ScreenWrapper) {
            return Optional.of((ScreenWrapper)screen);
        }
        return Optional.empty();
    }

    private ScreenWrapper(@NotNull GuiScreen screen) {
        super(RenderUtil.getTextConverter().convert(screen.getTitle()));
        this.screen = screen;
    }

    @NotNull
    public class_2561 method_25440() {
        if (this.screen == null) {
            return super.method_25440();
        }
        return RenderUtil.getTextConverter().convert(this.screen.getTitle());
    }

    public void method_25393() {
        this.screen.tick();
    }

    protected void method_25426() {
        this.screen.init();
        ModVoiceClient.INSTANCE.getEventBus().unregister((Object)ModVoiceClient.INSTANCE, (Object)this);
        ModVoiceClient.INSTANCE.getEventBus().register(ModVoiceClient.INSTANCE, (Object)this);
    }

    public void method_25432() {
        ModVoiceClient.INSTANCE.getEventBus().unregister((Object)ModVoiceClient.INSTANCE, (Object)this);
        this.screen.removed();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderUtil.preserveGlState();
        this.currentContext = guiGraphics;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.lastPartialTicks = partialTicks;
        GuiRenderContext context = new GuiRenderContext(guiGraphics);
        this.screen.render(context, mouseX, mouseY, partialTicks);
        this.currentContext = null;
        RenderUtil.restoreGlState();
    }

    public void renderBackground(@NotNull GuiRenderContext context) {
        if (this.currentContext == null) {
            return;
        }
        super.method_25420(this.currentContext, this.lastMouseX, this.lastMouseY, this.lastPartialTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        this.screen.mouseClicked(mouseX, mouseY, mouseButton);
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.screen.mouseReleased(mouseX, mouseY, button);
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.screen.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double delta) {
        this.screen.mouseScrolled(mouseX, mouseY, delta);
        return false;
    }

    public boolean method_25400(char typedChar, int modifiers) {
        return this.screen.charTyped(typedChar, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.innerKeyPressed(keyCode, scanCode, modifiers);
    }

    private boolean innerKeyPressed(int keyCode, int scanCode, int modifiers) {
        boolean shiftKeyDown;
        if (keyCode == 0) {
            return false;
        }
        if (this.screen.keyPressed(keyCode, modifiers)) {
            return true;
        }
        if (this.method_25422() && keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (keyCode == 258 && !this.screen.changeFocus(shiftKeyDown = Inputs.hasShiftDown())) {
            this.screen.changeFocus(shiftKeyDown);
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.screen.keyReleased(keyCode, '\u0000', modifiers)) {
            return false;
        }
        super.method_16803(keyCode, 0, modifiers);
        return false;
    }

    public boolean method_25422() {
        return this.screen.shouldCloseOnEsc();
    }

    public void method_25419() {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507(null));
    }

    public void renderTooltipWrapped(@NotNull GuiRenderContext context, @NotNull List<McTextComponent> tooltip, int mouseX, int mouseY) {
        this.method_47414(class_2477.method_10517().method_30933(new ArrayList(RenderUtil.getTextConverter().convert(tooltip))));
    }

    public String toString() {
        return "ScreenWrapper(screen=" + String.valueOf(this.getScreen()) + ", ignoreFirstMove=" + this.ignoreFirstMove + ", currentContext=" + String.valueOf(this.currentContext) + ", lastMouseX=" + this.lastMouseX + ", lastMouseY=" + this.lastMouseY + ", lastPartialTicks=" + this.lastPartialTicks + ")";
    }

    public GuiScreen getScreen() {
        return this.screen;
    }
}

